/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDialog
extends DialogWrapper
implements RunConfigurable.RunDialogBase {
    private final Project myProject;
    private final RunConfigurable myConfigurable;
    private JComponent myCenterPanel;
    @NonNls
    public static final String HELP_ID = "reference.dialogs.rundebug";
    private final Executor myExecutor;

    public RunDialog(Project project, Executor executor) {
        super(project, true);
        this.myProject = project;
        this.myExecutor = executor;
        String title = executor.getId();
        this.setTitle(title);
        this.setOKButtonText(executor.getStartActionText());
        this.setOKButtonIcon(executor.getIcon());
        this.myConfigurable = new RunConfigurable(project, this);
        this.init();
        this.myConfigurable.reset();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.RunDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    protected void doOKAction() {
        try {
            this.myConfigurable.apply();
        }
        catch (ConfigurationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    @Override
    public void setOKActionEnabled(boolean isEnabled) {
        super.setOKActionEnabled(isEnabled);
    }

    protected void dispose() {
        this.myConfigurable.disposeUIResources();
        super.dispose();
    }

    public static boolean editConfiguration(Project project, RunnerAndConfigurationSettings configuration, String title) {
        return RunDialog.editConfiguration(project, configuration, title, null);
    }

    public static boolean editConfiguration(Project project, RunnerAndConfigurationSettings configuration, String title, final @Nullable Executor executor) {
        SingleConfigurationConfigurable configurable = SingleConfigurationConfigurable.editSettings(configuration, executor);
        SingleConfigurableEditor dialog = new SingleConfigurableEditor(project, (Configurable)configurable, DialogWrapper.IdeModalityType.PROJECT){
            {
                super(x0, x1, x2);
                if (executor != null) {
                    this.setOKButtonText(executor.getActionName());
                }
                if (executor != null) {
                    this.setOKButtonIcon(executor.getIcon());
                }
            }
        };
        dialog.setTitle(title);
        dialog.show();
        return dialog.isOK();
    }

    @Override
    public Executor getExecutor() {
        return this.myExecutor;
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super(ExecutionBundle.message((String)"apply.action.name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                RunDialog.this.myConfigurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showMessageDialog((Project)RunDialog.this.myProject, (String)e.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
        }
    }
}

