/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionManagerImpl
extends ExecutionManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.impl.ExecutionManagerImpl");
    private final Project myProject;
    private RunContentManagerImpl myContentManager;
    private final Alarm awaitingTerminationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final List<Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor>> myRunningConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();

    ExecutionManagerImpl(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        ((RunContentManagerImpl)this.getContentManager()).init();
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            Disposer.dispose((Disposable)((Disposable)trinity.first));
        }
        this.myRunningConfigurations.clear();
    }

    @NotNull
    public RunContentManager getContentManager() {
        if (this.myContentManager == null) {
            this.myContentManager = new RunContentManagerImpl(this.myProject, DockManager.getInstance((Project)this.myProject));
            Disposer.register((Disposable)this.myProject, (Disposable)this.myContentManager);
        }
        RunContentManagerImpl runContentManagerImpl = this.myContentManager;
        if (runContentManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ExecutionManagerImpl", "getContentManager"));
        }
        return runContentManagerImpl;
    }

    public ProcessHandler[] getRunningProcesses() {
        ArrayList<ProcessHandler> handlers = new ArrayList<ProcessHandler>();
        for (RunContentDescriptor descriptor : this.getContentManager().getAllDescriptors()) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null) continue;
            handlers.add(processHandler);
        }
        return handlers.toArray(new ProcessHandler[handlers.size()]);
    }

    public void compileAndRun(final @NotNull Runnable startRunnable, final @NotNull ExecutionEnvironment env, @Nullable RunProfileState state, final @Nullable Runnable onCancelRunnable) {
        RunProfile profile;
        if (startRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "compileAndRun"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "compileAndRun"));
        }
        long id = env.getExecutionId();
        if (id == 0L) {
            id = env.assignNewExecutionId();
        }
        if ((profile = env.getRunProfile()) instanceof RunConfiguration) {
            DataContext projectContext;
            final RunConfiguration runConfiguration = (RunConfiguration)profile;
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
            final ArrayList<BeforeRunTask> activeTasks = new ArrayList<BeforeRunTask>();
            activeTasks.addAll(runManager.getBeforeRunTasks(runConfiguration));
            DataContext context = env.getDataContext();
            DataContext dataContext = projectContext = context != null ? context : SimpleDataContext.getProjectContext(this.myProject);
            if (!activeTasks.isEmpty()) {
                final long finalId = id;
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        for (BeforeRunTask task : activeTasks) {
                            if (ExecutionManagerImpl.this.myProject.isDisposed()) {
                                return;
                            }
                            BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)ExecutionManagerImpl.this.myProject, (Key)task.getProviderId());
                            if (provider == null) {
                                LOG.warn("Cannot find BeforeRunTaskProvider for id='" + task.getProviderId() + "'");
                                continue;
                            }
                            ExecutionEnvironment taskEnvironment = new ExecutionEnvironmentBuilder(env).setContentToReuse(null).build();
                            taskEnvironment.setExecutionId(finalId);
                            if (provider.executeTask(projectContext, runConfiguration, taskEnvironment, task)) continue;
                            if (onCancelRunnable != null) {
                                SwingUtilities.invokeLater(onCancelRunnable);
                            }
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ExecutionManagerImpl.this.myProject.isDisposed()) {
                                    DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).runWhenSmart(startRunnable);
                                }
                            }
                        });
                    }
                });
            } else {
                startRunnable.run();
            }
        } else {
            startRunnable.run();
        }
    }

    public void startRunProfile(final @NotNull RunProfileStarter starter, final @NotNull RunProfileState state, final @NotNull Project project, final @NotNull Executor executor, final @NotNull ExecutionEnvironment env) {
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        final RunContentDescriptor reuseContent = ExecutionManager.getInstance((Project)project).getContentManager().getReuseContent(env);
        if (reuseContent != null) {
            reuseContent.setExecutionId(env.getExecutionId());
        }
        final RunProfile profile = env.getRunProfile();
        ((ExecutionListener)project.getMessageBus().syncPublisher(EXECUTION_TOPIC)).processStartScheduled(executor.getId(), env);
        Runnable startRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                boolean started = false;
                try {
                    ((ExecutionListener)project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarting(executor.getId(), env);
                    RunContentDescriptor descriptor = starter.execute(project, executor, state, reuseContent, env);
                    if (descriptor != null) {
                        final Trinity trinity = Trinity.create((Object)descriptor, (Object)env.getRunnerAndConfigurationSettings(), (Object)executor);
                        ExecutionManagerImpl.this.myRunningConfigurations.add(trinity);
                        Disposer.register((Disposable)descriptor, (Disposable)new Disposable(){

                            public void dispose() {
                                ExecutionManagerImpl.this.myRunningConfigurations.remove(trinity);
                            }
                        });
                        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor, reuseContent);
                        ProcessHandler processHandler = descriptor.getProcessHandler();
                        if (processHandler != null) {
                            processHandler.startNotify();
                            ((ExecutionListener)project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarted(executor.getId(), env, processHandler);
                            started = true;
                            processHandler.addProcessListener((ProcessListener)new ProcessExecutionListener(project, profile, processHandler));
                        }
                    }
                }
                catch (ExecutionException e) {
                    ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (RunProfile)profile, (ExecutionException)e);
                    LOG.info((Throwable)e);
                }
                finally {
                    if (!started) {
                        ((ExecutionListener)project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processNotStarted(executor.getId(), env);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            startRunnable.run();
        } else {
            this.compileAndRun(startRunnable, env, state, new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        ((ExecutionListener)project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processNotStarted(executor.getId(), env);
                    }
                }
            });
        }
    }

    public void startRunProfile(@NotNull RunProfileStarter starter, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) {
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/impl/ExecutionManagerImpl", "startRunProfile"));
        }
        this.startRunProfile(starter, state, env.getProject(), env.getExecutor(), env);
    }

    public void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunnerAndConfigurationSettings configuration, @Nullable ProcessHandler processHandler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (processHandler != null) {
            for (RunContentDescriptor descriptor : this.getContentManager().getAllDescriptors()) {
                ProcessHandler handler = descriptor.getProcessHandler();
                if (handler != processHandler) continue;
                this.restartRunProfile(project, null, null, null, null, null, executor, target, configuration, descriptor);
                return;
            }
        }
        this.restartRunProfile(project, null, null, null, null, null, executor, target, configuration, null);
    }

    public void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunnerAndConfigurationSettings configuration, @Nullable RunContentDescriptor currentDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        this.restartRunProfile(project, null, null, null, null, null, executor, target, configuration, currentDescriptor);
    }

    public void restartRunProfile(@Nullable ProgramRunner runner, @NotNull ExecutionEnvironment environment, @Nullable RunContentDescriptor currentDescriptor) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        this.restartRunProfile(environment.getProject(), environment.getDataContext(), runner, environment.getRunProfile(), environment.getRunnerSettings(), environment.getConfigurationSettings(), environment.getExecutor(), environment.getExecutionTarget(), environment.getRunnerAndConfigurationSettings(), currentDescriptor);
    }

    private void restartRunProfile(final @NotNull Project project, final @Nullable DataContext context, @Nullable ProgramRunner r, final @Nullable RunProfile runProfile, final @Nullable RunnerSettings runnerSettings, final @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings, final @NotNull Executor executor, final @NotNull ExecutionTarget target, final @Nullable RunnerAndConfigurationSettings configuration, final @Nullable RunContentDescriptor currentDescriptor) {
        ProgramRunner runner;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/execution/impl/ExecutionManagerImpl", "restartRunProfile"));
        }
        ProgramRunner programRunner = r != null ? r : (runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)(configuration != null && configuration.getConfiguration() != null ? configuration.getConfiguration() : runProfile)));
        if (configuration != null && runner == null) {
            LOG.error("Cannot find runner for " + configuration.getName());
            return;
        }
        final ArrayList<RunContentDescriptor> runningConfigurationsOfTheSameType = new ArrayList<RunContentDescriptor>();
        ArrayList<RunContentDescriptor> runningIncompatibleConfigurations = new ArrayList<RunContentDescriptor>();
        if (configuration != null) {
            runningIncompatibleConfigurations.addAll(this.getIncompatibleRunningDescriptors(configuration));
        }
        if (configuration != null && configuration.isSingleton()) {
            runningConfigurationsOfTheSameType.addAll(this.getRunningDescriptorsOfTheSameConfigType(configuration));
        } else if (currentDescriptor != null) {
            runningConfigurationsOfTheSameType.add(currentDescriptor);
        }
        List runningConfigurationsToStop = ContainerUtil.concat(runningConfigurationsOfTheSameType, runningIncompatibleConfigurations);
        if (!runningConfigurationsToStop.isEmpty()) {
            if (configuration != null) {
                if (!(runningConfigurationsOfTheSameType.isEmpty() || runningConfigurationsOfTheSameType.size() <= 1 && currentDescriptor != null && runningConfigurationsOfTheSameType.get(0) == currentDescriptor || ExecutionManagerImpl.userApprovesStopForSameTypeConfigurations(project, configuration.getName(), runningConfigurationsOfTheSameType.size()))) {
                    return;
                }
                if (!runningIncompatibleConfigurations.isEmpty() && !ExecutionManagerImpl.userApprovesStopForIncompatibleConfigurations(this.myProject, configuration.getName(), runningIncompatibleConfigurations)) {
                    return;
                }
            }
            for (RunContentDescriptor descriptor : runningConfigurationsToStop) {
                ExecutionManagerImpl.stop(descriptor);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (runner != null && ExecutorRegistry.getInstance().isStarting(project, executor.getId(), runner.getRunnerId())) {
                    ExecutionManagerImpl.this.awaitingTerminationAlarm.addRequest((Runnable)this, 100);
                    return;
                }
                for (RunContentDescriptor descriptor : runningConfigurationsOfTheSameType) {
                    ProcessHandler processHandler = descriptor.getProcessHandler();
                    if (processHandler == null || processHandler.isProcessTerminated()) continue;
                    ExecutionManagerImpl.this.awaitingTerminationAlarm.addRequest((Runnable)this, 100);
                    return;
                }
                ExecutionManagerImpl.start(project, context, runner, runProfile, runnerSettings, configurationPerRunnerSettings, configuration, executor, target, currentDescriptor);
            }
        };
        this.awaitingTerminationAlarm.addRequest(runnable, 50);
    }

    private static void start(@NotNull Project project, @Nullable DataContext context, @Nullable ProgramRunner runner, @Nullable RunProfile runProfile, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings, @Nullable RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunContentDescriptor descriptor) {
        Runnable restarter;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "start"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/execution/impl/ExecutionManagerImpl", "start"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "com/intellij/execution/impl/ExecutionManagerImpl", "start"));
        }
        Runnable runnable = restarter = descriptor != null ? descriptor.getRestarter() : null;
        if (runner != null && runProfile != null) {
            ProgramRunnerUtil.executeConfiguration(project, context, configuration, executor, target, descriptor, configuration != null && configuration.isEditBeforeRun(), runner, runProfile, false);
        } else if (configuration != null) {
            ProgramRunnerUtil.executeConfiguration(project, context, configuration, executor, target, descriptor, true);
        } else if (restarter != null) {
            restarter.run();
        }
    }

    private static boolean userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        final RunManagerConfig config = runManager.getConfig();
        if (!config.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config.setRestartRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    private static boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        final RunManagerConfig config = runManager.getConfig();
        if (!config.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config.setStopIncompatibleRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        StringBuilder names = new StringBuilder();
        for (RunContentDescriptor descriptor : runningIncompatibleDescriptors) {
            String name = descriptor.getDisplayName();
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(StringUtil.isEmpty((String)name) ? ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]) : String.format("'%s'", name));
        }
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    private List<RunContentDescriptor> getRunningDescriptorsOfTheSameConfigType(final @NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        if (configurationAndSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "getRunningDescriptorsOfTheSameConfigType"));
        }
        return this.getRunningDescriptors(new Predicate<RunnerAndConfigurationSettings>(){

            public boolean apply(@Nullable RunnerAndConfigurationSettings runningConfigurationAndSettings) {
                return configurationAndSettings == runningConfigurationAndSettings;
            }
        });
    }

    private List<RunContentDescriptor> getIncompatibleRunningDescriptors(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        if (configurationAndSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/ExecutionManagerImpl", "getIncompatibleRunningDescriptors"));
        }
        final RunConfiguration configurationToCheckCompatibility = configurationAndSettings.getConfiguration();
        return this.getRunningDescriptors(new Predicate<RunnerAndConfigurationSettings>(){

            public boolean apply(@Nullable RunnerAndConfigurationSettings runningConfigurationAndSettings) {
                if (runningConfigurationAndSettings == null) {
                    return false;
                }
                RunConfiguration runningConfiguration = runningConfigurationAndSettings.getConfiguration();
                if (runningConfiguration == null || !(runningConfiguration instanceof CompatibilityAwareRunProfile)) {
                    return false;
                }
                return ((CompatibilityAwareRunProfile)runningConfiguration).mustBeStoppedToRun(configurationToCheckCompatibility);
            }
        });
    }

    private List<RunContentDescriptor> getRunningDescriptors(Predicate<RunnerAndConfigurationSettings> condition) {
        ArrayList<RunContentDescriptor> result = new ArrayList<RunContentDescriptor>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            ProcessHandler processHandler;
            if (!condition.apply(trinity.getSecond()) || (processHandler = ((RunContentDescriptor)trinity.getFirst()).getProcessHandler()) == null || processHandler.isProcessTerminating() || processHandler.isProcessTerminated()) continue;
            result.add((RunContentDescriptor)trinity.getFirst());
        }
        return result;
    }

    private static void stop(RunContentDescriptor runContentDescriptor) {
        ProcessHandler processHandler;
        ProcessHandler processHandler2 = processHandler = runContentDescriptor != null ? runContentDescriptor.getProcessHandler() : null;
        if (processHandler == null) {
            return;
        }
        if (processHandler instanceof KillableProcess && processHandler.isProcessTerminating()) {
            ((KillableProcess)processHandler).killProcess();
            return;
        }
        if (processHandler.detachIsDefault()) {
            processHandler.detachProcess();
        } else {
            processHandler.destroyProcess();
        }
    }

    @NotNull
    public String getComponentName() {
        if ("ExecutionManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ExecutionManagerImpl", "getComponentName"));
        }
        return "ExecutionManager";
    }

    private static class ProcessExecutionListener
    extends ProcessAdapter {
        private final Project myProject;
        private final RunProfile myProfile;
        private final ProcessHandler myProcessHandler;

        public ProcessExecutionListener(Project project, RunProfile profile, ProcessHandler processHandler) {
            this.myProject = project;
            this.myProfile = profile;
            this.myProcessHandler = processHandler;
        }

        public void processTerminated(ProcessEvent event) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((ExecutionListener)this.myProject.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminated(this.myProfile, this.myProcessHandler);
            VirtualFileManager.getInstance().asyncRefresh(null);
        }

        public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((ExecutionListener)this.myProject.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminating(this.myProfile, this.myProcessHandler);
        }
    }
}

