/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHyperlinkSupport {
    public static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    private static final int HYPERLINK_LAYER = 5877;
    private static final int HIGHLIGHT_LAYER = 5889;
    private static final int NO_INDEX = Integer.MIN_VALUE;
    public static final Comparator<RangeHighlighter> START_OFFSET_COMPARATOR = new Comparator<RangeHighlighter>(){

        @Override
        public int compare(RangeHighlighter o1, RangeHighlighter o2) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    private final SortedMap<RangeHighlighter, HyperlinkInfo> myHighlighterToMessageInfoMap;
    private int myLastIndex;
    private final List<RangeHighlighter> myHighlighters;

    public EditorHyperlinkSupport(final @NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/EditorHyperlinkSupport", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/EditorHyperlinkSupport", "<init>"));
        }
        this.myHighlighterToMessageInfoMap = new TreeMap<RangeHighlighter, HyperlinkInfo>(START_OFFSET_COMPARATOR);
        this.myLastIndex = Integer.MIN_VALUE;
        this.myEditor = editor;
        this.myProject = project;
        this.myHighlighters = new SmartList();
        editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e) {
                Runnable runnable;
                MouseEvent mouseEvent = e.getMouseEvent();
                if (mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger() && (runnable = EditorHyperlinkSupport.this.getLinkNavigationRunnable(EditorHyperlinkSupport.this.myEditor.xyToLogicalPosition(e.getMouseEvent().getPoint()))) != null) {
                    runnable.run();
                }
            }
        });
        editor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HyperlinkInfo info = EditorHyperlinkSupport.this.getHyperlinkInfoByPoint(e.getPoint());
                if (info != null) {
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    Cursor cursor = editor instanceof EditorEx ? UIUtil.getTextCursor((Color)((EditorEx)editor).getBackgroundColor()) : Cursor.getPredefinedCursor(2);
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(cursor);
                }
            }
        });
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(final LogicalPosition logical) {
        HyperlinkInfo info;
        if (EditorUtil.inVirtualSpace(this.myEditor, logical)) {
            return null;
        }
        final RangeHighlighter range = this.findLinkRangeAt(this.myEditor.logicalPositionToOffset(logical));
        if (range != null && (info = (HyperlinkInfo)this.myHighlighterToMessageInfoMap.get(range)) != null) {
            return new Runnable(){

                @Override
                public void run() {
                    if (info instanceof HyperlinkInfoBase) {
                        RelativePoint point = new RelativePoint((Component)EditorHyperlinkSupport.this.myEditor.getContentComponent(), EditorHyperlinkSupport.this.myEditor.logicalPositionToXY(logical));
                        ((HyperlinkInfoBase)info).navigate(EditorHyperlinkSupport.this.myProject, point);
                    } else {
                        info.navigate(EditorHyperlinkSupport.this.myProject);
                    }
                    EditorHyperlinkSupport.linkFollowed(EditorHyperlinkSupport.this.myEditor, EditorHyperlinkSupport.this.getHyperlinks().keySet(), range);
                }
            };
        }
        return null;
    }

    public void adjustHighlighters(List<FilterMixin.AdditionalHighlight> highlights) {
        for (FilterMixin.AdditionalHighlight highlight : highlights) {
            RangeHighlighter found = null;
            for (RangeHighlighter rangeHighlighter : this.myHighlighterToMessageInfoMap.keySet()) {
                if (rangeHighlighter.getStartOffset() > highlight.getStart() || rangeHighlighter.getEndOffset() < highlight.getEnd()) continue;
                found = rangeHighlighter;
                break;
            }
            if (found != null) {
                TextAttributes textAttributes = highlight.getTextAttributes(found.getTextAttributes());
                HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)this.myHighlighterToMessageInfoMap.remove(found);
                if (found.getStartOffset() != highlight.getStart()) {
                    this.addHyperlink(found.getStartOffset(), highlight.getEnd(), found.getTextAttributes(), hyperlinkInfo);
                }
                if (found.getEndOffset() != highlight.getEnd()) {
                    this.addHyperlink(highlight.getEnd(), found.getEndOffset(), found.getTextAttributes(), hyperlinkInfo);
                }
                this.addHyperlink(highlight.getStart(), highlight.getEnd(), textAttributes, hyperlinkInfo);
                this.myEditor.getMarkupModel().removeHighlighter(found);
                return;
            }
            Iterator<RangeHighlighter> iterator = this.myHighlighters.iterator();
            while (iterator.hasNext()) {
                RangeHighlighter highlighter = iterator.next();
                if (highlighter.getStartOffset() != highlight.getStart() || highlighter.getEndOffset() != highlight.getEnd()) continue;
                iterator.remove();
                TextAttributes textAttributes = highlight.getTextAttributes(highlighter.getTextAttributes());
                this.addHighlighter(highlight.getStart(), highlight.getEnd(), textAttributes);
                return;
            }
            TextAttributes textAttributes = highlight.getTextAttributes(null);
            this.addHighlighter(highlight.getStart(), highlight.getEnd(), textAttributes);
        }
    }

    public void clearHyperlinks() {
        this.myHighlighterToMessageInfoMap.clear();
        this.myHighlighters.clear();
        this.myLastIndex = Integer.MIN_VALUE;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        for (RangeHighlighter highlighter : this.myHighlighterToMessageInfoMap.keySet()) {
            if (!highlighter.isValid() || !EditorHyperlinkSupport.containsOffset(offset, highlighter)) continue;
            return highlighter;
        }
        return null;
    }

    @Nullable
    private HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range = this.findLinkRangeAt(offset);
        return range == null ? null : (HyperlinkInfo)this.myHighlighterToMessageInfoMap.get(range);
    }

    @Nullable
    public RangeHighlighter findHyperlinkRange(HyperlinkInfo info) {
        for (RangeHighlighter highlighter : this.myHighlighterToMessageInfoMap.keySet()) {
            if (info != this.myHighlighterToMessageInfoMap.get(highlighter)) continue;
            return highlighter;
        }
        return null;
    }

    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        for (RangeHighlighter highlighter : this.myHighlighterToMessageInfoMap.keySet()) {
            int hyperlinkStart = highlighter.getStartOffset();
            int hyperlinkEnd = highlighter.getEndOffset();
            if (hyperlinkStart < lineStart || hyperlinkEnd > lineEnd) continue;
            list.add(highlighter);
        }
        return list;
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        if (hyperlink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/EditorHyperlinkSupport", "removeHyperlink"));
        }
        this.myHighlighterToMessageInfoMap.remove(hyperlink);
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    private static boolean containsOffset(int offset, RangeHighlighter highlighter) {
        return highlighter.getStartOffset() <= offset && offset <= highlighter.getEndOffset();
    }

    public void addHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/EditorHyperlinkSupport", "addHyperlink"));
        }
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/EditorHyperlinkSupport", "addHyperlink"));
        }
        this.myHighlighterToMessageInfoMap.put(highlighter, hyperlinkInfo);
        if (this.myLastIndex != Integer.MIN_VALUE && EditorHyperlinkSupport.containsOffset(this.myLastIndex, highlighter)) {
            this.myLastIndex = Integer.MIN_VALUE;
        }
    }

    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        return this.myHighlighterToMessageInfoMap;
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    public void addHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/impl/EditorHyperlinkSupport", "addHyperlink"));
        }
        TextAttributes textAttributes = highlightAttributes != null ? highlightAttributes : EditorHyperlinkSupport.getHyperlinkAttributes();
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, 5877, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        this.addHyperlink(highlighter, hyperlinkInfo);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorUtil.inVirtualSpace(this.myEditor, pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    public void highlightHyperlinks(Filter customFilter, Filter predefinedMessageFilter, int line1, int endLine) {
        int startLine;
        Document document = this.myEditor.getDocument();
        for (int line = startLine = Math.max(0, line1); line <= endLine; ++line) {
            String text;
            Filter.Result result;
            int endOffset = document.getLineEndOffset(line);
            if (endOffset < document.getTextLength()) {
                ++endOffset;
            }
            if ((result = customFilter.applyFilter(text = EditorHyperlinkSupport.getLineText(document, line, true), endOffset)) == null) {
                result = predefinedMessageFilter.applyFilter(text, endOffset);
            }
            if (result == null) continue;
            for (Filter.ResultItem resultItem : result.getResultItems()) {
                if (resultItem.hyperlinkInfo != null) {
                    this.addHyperlink(resultItem.highlightStartOffset, resultItem.highlightEndOffset, resultItem.highlightAttributes, resultItem.hyperlinkInfo);
                    continue;
                }
                if (resultItem.highlightAttributes == null) continue;
                this.addHighlighter(resultItem.highlightStartOffset, resultItem.highlightEndOffset, resultItem.highlightAttributes);
            }
        }
    }

    private void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, 5889, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
        this.myHighlighters.add(highlighter);
    }

    private static TextAttributes getHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    private static TextAttributes getFollowedHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
    }

    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(final Editor editor, Collection<RangeHighlighter> sortedHighlighters, int delta, final Consumer<RangeHighlighter> action) {
        RangeHighlighter range;
        int i;
        if (sortedHighlighters.isEmpty()) {
            return null;
        }
        final ArrayList<RangeHighlighter> ranges = new ArrayList<RangeHighlighter>(sortedHighlighters);
        for (i = 0; i < ranges.size() && (range = (RangeHighlighter)ranges.get(i)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i) {
        }
        int newIndex = i %= ranges.size();
        while (newIndex < ranges.size() && newIndex >= 0) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = (RangeHighlighter)ranges.get(newIndex);
            if (editor.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) == null) {
                return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        action.consume((Object)next);
                        EditorHyperlinkSupport.linkFollowed(editor, ranges, next);
                    }
                }, newIndex == -1 ? -1 : newIndex + 1, ranges.size());
            }
            if (newIndex != i) continue;
            break;
        }
        return null;
    }

    private static void linkFollowed(Editor editor, Collection<RangeHighlighter> ranges, RangeHighlighter link) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        for (RangeHighlighter range : ranges) {
            TextAttributes oldAttr = (TextAttributes)range.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(range, oldAttr);
                range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (range != link) continue;
            range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)range.getTextAttributes());
            markupModel.setRangeHighlighterAttributes(range, EditorHyperlinkSupport.getFollowedHyperlinkAttributes());
        }
        markupModel.addRangeHighlighter(0, 0, 5877, EditorHyperlinkSupport.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE).dispose();
    }

    public static String getLineText(Document document, int lineNumber, boolean includeEol) {
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        return ((Object)document.getCharsSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset)).toString();
    }
}

