/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextConsoleBuilderImpl
extends TextConsoleBuilder {
    private final Project myProject;
    private final GlobalSearchScope myScope;
    private final ArrayList<Filter> myFilters;
    private boolean myViewer;
    private boolean myUsePredefinedMessageFilter;

    public TextConsoleBuilderImpl(Project project) {
        this(project, GlobalSearchScope.allScope((Project)project));
    }

    public TextConsoleBuilderImpl(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/TextConsoleBuilderImpl", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/filters/TextConsoleBuilderImpl", "<init>"));
        }
        this.myFilters = new ArrayList();
        this.myUsePredefinedMessageFilter = true;
        this.myProject = project;
        this.myScope = scope;
    }

    public ConsoleView getConsole() {
        ConsoleView consoleView = this.createConsole();
        for (Filter filter : this.myFilters) {
            consoleView.addMessageFilter(filter);
        }
        return consoleView;
    }

    protected ConsoleView createConsole() {
        return new ConsoleViewImpl(this.myProject, this.myScope, this.myViewer, this.myUsePredefinedMessageFilter);
    }

    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
    }

    public TextConsoleBuilder filters(List<Filter> filters) {
        this.myFilters.addAll(filters);
        return this;
    }

    public void setViewer(boolean isViewer) {
        this.myViewer = isViewer;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    protected ArrayList<Filter> getFilters() {
        return this.myFilters;
    }

    protected boolean isViewer() {
        return this.myViewer;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }
}

