/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleFoldingConfigurable;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldLinesLikeThis
extends DumbAwareAction {
    @Nullable
    private static String getSingleLineSelection(@NotNull Editor editor) {
        String selection;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/FoldLinesLikeThis", "getSingleLineSelection"));
        }
        SelectionModel model = editor.getSelectionModel();
        Document document = editor.getDocument();
        if (!model.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            if (offset <= document.getTextLength()) {
                int lineNumber = document.getLineNumber(offset);
                String line = document.getText().substring(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)).trim();
                if (StringUtil.isNotEmpty((String)line)) {
                    return line;
                }
            }
            return null;
        }
        int start = model.getSelectionStart();
        int end = model.getSelectionEnd();
        if (document.getLineNumber(start) == document.getLineNumber(end) && StringUtil.isNotEmpty((String)(selection = document.getText().substring(start, end).trim()))) {
            return selection;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null && editor != null && FoldLinesLikeThis.getSingleLineSelection(editor) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        assert (editor != null);
        final String selection = FoldLinesLikeThis.getSingleLineSelection(editor);
        assert (selection != null);
        ShowSettingsUtil.getInstance().editConfigurable(editor.getProject(), (Configurable)new ConsoleFoldingConfigurable(){

            @Override
            public void reset() {
                super.reset();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.addRule(selection);
                    }
                }, ModalityState.stateForComponent((Component)this.createComponent()));
            }
        });
        ConsoleView consoleView = (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW);
        if (consoleView instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)consoleView).foldImmediately();
        }
    }
}

