/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ConsoleHistoryModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecuteAction
extends DumbAwareAction {
    static final String CONSOLE_EXECUTE_ACTION_ID = "Console.Execute";
    private final LanguageConsoleView myConsoleView;
    private final LanguageConsoleImpl myConsole;
    private final ConsoleExecuteActionHandler myExecuteActionHandler;
    private final Condition<LanguageConsoleImpl> myEnabledCondition;

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, (Condition<LanguageConsoleImpl>)Conditions.alwaysTrue());
    }

    public static ConsoleExecuteAction createAction(final @NotNull LanguageConsoleImpl languageConsole, @NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (languageConsole == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "createAction"));
        }
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "createAction"));
        }
        final ProcessBackedConsoleExecuteActionHandler handler = consoleExecuteActionHandler;
        return new ConsoleExecuteAction(languageConsole, new ConsoleExecuteActionHandler(handler.myPreserveMarkup){

            @Override
            void doExecute(@NotNull String text, @NotNull LanguageConsoleImpl console, @Nullable LanguageConsoleView consoleView) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction$1", "doExecute"));
                }
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction$1", "doExecute"));
                }
                handler.doExecute(text, languageConsole, null);
            }
        }, (Condition<LanguageConsoleImpl>)consoleExecuteActionHandler);
    }

    ConsoleExecuteAction(@NotNull LanguageConsoleImpl console, @NotNull ConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleImpl> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console, null, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleImpl> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console.getConsole(), console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @NotNull Condition<LanguageConsoleImpl> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (emptyExecuteActionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (enabledCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console.getConsole(), console, executeActionHandler, emptyExecuteActionId, enabledCondition);
    }

    private ConsoleExecuteAction(@NotNull LanguageConsoleImpl console, @Nullable LanguageConsoleView consoleView, @NotNull ConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @Nullable Condition<LanguageConsoleImpl> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (emptyExecuteActionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        super(null, null, AllIcons.Actions.Execute);
        this.myConsole = console;
        this.myConsoleView = consoleView;
        this.myExecuteActionHandler = executeActionHandler;
        this.myEnabledCondition = enabledCondition == null ? Conditions.alwaysTrue() : enabledCondition;
        EmptyAction.setupAction((AnAction)this, (String)emptyExecuteActionId, null);
    }

    public final void update(AnActionEvent e) {
        boolean enabled;
        EditorEx editor = this.myConsole.getConsoleEditor();
        boolean bl = enabled = !editor.isRendererMode() && this.isEnabled() && (this.myExecuteActionHandler.isEmptyCommandExecutionAllowed() || !StringUtil.isEmptyOrSpaces((CharSequence)editor.getDocument().getCharsSequence()));
        if (enabled) {
            LookupEx lookup = LookupManager.getActiveLookup(editor);
            enabled = lookup == null || !lookup.isCompletion() || lookup.getCurrentItem() == null;
        }
        e.getPresentation().setEnabled(enabled);
    }

    public final void actionPerformed(AnActionEvent e) {
        this.myExecuteActionHandler.runExecuteAction(this.myConsole, this.myConsoleView);
    }

    public boolean isEnabled() {
        return this.myEnabledCondition.value((Object)this.myConsole);
    }

    public void execute(@Nullable TextRange range, @NotNull String text, @Nullable EditorEx editor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/ConsoleExecuteAction", "execute"));
        }
        if (range == null) {
            this.myConsole.doAddPromptToHistory();
            DocumentEx document = this.myConsole.getHistoryViewer().getDocument();
            document.insertString(document.getTextLength(), text);
            if (!text.endsWith("\n")) {
                document.insertString(document.getTextLength(), "\n");
            }
        } else {
            assert (editor != null);
            this.myConsole.addTextRangeToHistory(range, editor, this.myExecuteActionHandler.myPreserveMarkup);
        }
        this.myExecuteActionHandler.addToCommandHistoryAndExecute(this.myConsole, this.myConsoleView, text);
    }

    static abstract class ConsoleExecuteActionHandler {
        private final ConsoleHistoryModel myCommandHistoryModel = new ConsoleHistoryModel();
        private boolean myAddToHistory = true;
        final boolean myPreserveMarkup;

        public ConsoleExecuteActionHandler(boolean preserveMarkup) {
            this.myPreserveMarkup = preserveMarkup;
        }

        public ConsoleHistoryModel getConsoleHistoryModel() {
            return this.myCommandHistoryModel;
        }

        public boolean isEmptyCommandExecutionAllowed() {
            return true;
        }

        public final void setAddCurrentToHistory(boolean addCurrentToHistory) {
            this.myAddToHistory = addCurrentToHistory;
        }

        protected void beforeExecution(@NotNull LanguageConsoleImpl console) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "beforeExecution"));
            }
        }

        final void runExecuteAction(@NotNull LanguageConsoleImpl console, @Nullable LanguageConsoleView consoleView) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "runExecuteAction"));
            }
            this.beforeExecution(console);
            String text = console.prepareExecuteAction(this.myAddToHistory, this.myPreserveMarkup, true);
            ((UndoManagerImpl)UndoManager.getInstance((Project)console.getProject())).invalidateActionsFor(DocumentReferenceManager.getInstance().create(console.getCurrentEditor().getDocument()));
            this.addToCommandHistoryAndExecute(console, consoleView, text);
        }

        private void addToCommandHistoryAndExecute(@NotNull LanguageConsoleImpl console, @Nullable LanguageConsoleView consoleView, @NotNull String text) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "addToCommandHistoryAndExecute"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "addToCommandHistoryAndExecute"));
            }
            this.myCommandHistoryModel.addToHistory(text);
            this.doExecute(text, console, consoleView);
        }

        abstract void doExecute(@NotNull String var1, @NotNull LanguageConsoleImpl var2, @Nullable LanguageConsoleView var3);
    }
}

