/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public void update(AnActionEvent e) {
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if ("MainMenu".equals(e.getPlace())) {
            enable = !StopAction.getCancellableProcesses(e.getProject()).isEmpty() || !StopAction.getActiveDescriptors(e.getDataContext()).isEmpty();
        } else {
            ProcessHandler processHandler = StopAction.getHandler(e.getDataContext());
            if (processHandler != null && !processHandler.isProcessTerminated()) {
                if (!processHandler.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        ProcessHandler activeProcessHandler = StopAction.getHandler(dataContext);
        List<Pair<TaskInfo, ProgressIndicator>> backgroundTasks = StopAction.getCancellableProcesses(e.getProject());
        if ("MainMenu".equals(e.getPlace())) {
            if (activeProcessHandler != null && !activeProcessHandler.isProcessTerminating() && !activeProcessHandler.isProcessTerminated() && backgroundTasks.isEmpty()) {
                StopAction.stopProcess(activeProcessHandler);
                return;
            }
            Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(backgroundTasks, StopAction.getActiveDescriptors(dataContext), activeProcessHandler);
            if (((List)handlerItems.first).isEmpty()) {
                return;
            }
            final JBList list = new JBList((Collection)handlerItems.first);
            if (handlerItems.second != null) {
                list.setSelectedValue(handlerItems.second, true);
            }
            list.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer(new ListItemDescriptor(){

                @Nullable
                public String getTextFor(Object value) {
                    return value instanceof HandlerItem ? ((HandlerItem)value).displayName : null;
                }

                @Nullable
                public String getTooltipFor(Object value) {
                    return null;
                }

                @Nullable
                public Icon getIconFor(Object value) {
                    return value instanceof HandlerItem ? ((HandlerItem)value).icon : null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return value instanceof HandlerItem && ((HandlerItem)value).hasSeparator;
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return null;
                }
            }));
            PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
            JBPopup popup = builder.setMovable(true).setTitle(((List)handlerItems.first).size() == 1 ? "Confirm process stop" : "Stop process").setFilteringEnabled((Function)new Function<Object, String>(){

                public String fun(Object o) {
                    return ((HandlerItem)o).displayName;
                }
            }).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    HandlerItem item = (HandlerItem)list.getSelectedValue();
                    if (item != null) {
                        item.stop();
                    }
                }
            }).setRequestFocus(true).createPopup();
            popup.showCenteredInCurrentWindow(e.getProject());
        } else if (activeProcessHandler != null) {
            StopAction.stopProcess(activeProcessHandler);
        }
    }

    private static List<Pair<TaskInfo, ProgressIndicator>> getCancellableProcesses(Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll(statusBar.getBackgroundProcesses(), (Condition)new Condition<Pair<TaskInfo, ProgressIndicator>>(){

            public boolean value(Pair<TaskInfo, ProgressIndicator> pair) {
                return ((TaskInfo)pair.first).isCancellable() && !((ProgressIndicator)pair.second).isCanceled();
            }
        });
    }

    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<Pair<TaskInfo, ProgressIndicator>> tasks, List<RunContentDescriptor> descriptors, ProcessHandler activeProcessHandler) {
        if (tasks.isEmpty() && descriptors.isEmpty()) {
            return Pair.create(Collections.emptyList(), null);
        }
        ArrayList<HandlerItem> items = new ArrayList<HandlerItem>(tasks.size() + descriptors.size());
        HandlerItem selected = null;
        for (RunContentDescriptor descriptor : descriptors) {
            final ProcessHandler handler = descriptor.getProcessHandler();
            if (handler == null) continue;
            HandlerItem item = new HandlerItem(descriptor.getDisplayName(), descriptor.getIcon(), false){

                @Override
                void stop() {
                    StopAction.stopProcess(handler);
                }
            };
            items.add(item);
            if (handler != activeProcessHandler) continue;
            selected = item;
        }
        boolean hasSeparator = true;
        for (final Pair<TaskInfo, ProgressIndicator> eachPair : tasks) {
            items.add(new HandlerItem(((TaskInfo)eachPair.first).getTitle(), AllIcons.Process.Step_passive, hasSeparator){

                @Override
                void stop() {
                    ((ProgressIndicator)eachPair.second).cancel();
                }
            });
            hasSeparator = false;
        }
        return Pair.create(items, selected);
    }

    private static void stopProcess(ProcessHandler processHandler) {
        if (processHandler instanceof KillableProcess && processHandler.isProcessTerminating()) {
            ((KillableProcess)processHandler).killProcess();
            return;
        }
        if (processHandler.detachIsDefault()) {
            processHandler.detachProcess();
        } else {
            processHandler.destroyProcess();
        }
    }

    @Nullable
    private static ProcessHandler getHandler(DataContext dataContext) {
        ProcessHandler processHandler;
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)RunContentManager.RUN_CONTENT_DESCRIPTOR.getData(dataContext);
        if (contentDescriptor != null) {
            processHandler = contentDescriptor.getProcessHandler();
        } else {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            RunContentDescriptor selectedContent = project == null ? null : ExecutionManager.getInstance((Project)project).getContentManager().getSelectedContent();
            processHandler = selectedContent == null ? null : selectedContent.getProcessHandler();
        }
        return processHandler;
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveDescriptors(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveDescriptors"));
            }
            return list;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveDescriptors"));
            }
            return list;
        }
        ArrayList<RunContentDescriptor> activeDescriptors = new ArrayList<RunContentDescriptor>();
        for (RunContentDescriptor descriptor : runningProcesses) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminating() || processHandler.isProcessTerminated()) continue;
            activeDescriptors.add(descriptor);
        }
        ArrayList<RunContentDescriptor> arrayList = activeDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveDescriptors"));
        }
        return arrayList;
    }

    private static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        private HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

