/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.ide.util.PropertiesComponent;
import org.jetbrains.annotations.NonNls;

public class RunManagerConfig {
    public static final String MAKE = ExecutionBundle.message((String)"before.run.property.make", (Object[])new Object[0]);
    private final StoringPropertyContainer myProperties;
    private final PropertiesComponent myPropertiesComponent;
    public static final int MIN_RECENT_LIMIT = 0;
    @NonNls
    private static final String RECENTS_LIMIT = "recentsLimit";
    @NonNls
    private static final String RESTART_REQUIRES_CONFIRMATION = "restartRequiresConfirmation";
    @NonNls
    private static final String STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION = "stopIncompatibleRequiresConfirmation";

    public RunManagerConfig(PropertiesComponent propertiesComponent, RunManagerImpl manager) {
        this.myPropertiesComponent = propertiesComponent;
        this.myProperties = new StoringPropertyContainer("RunManagerConfig.", propertiesComponent);
    }

    public int getRecentsLimit() {
        try {
            return Math.max(0, Integer.valueOf(this.myPropertiesComponent.getOrInit(RECENTS_LIMIT, "5")));
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public void setRecentsLimit(int recentsLimit) {
        this.myPropertiesComponent.setValue(RECENTS_LIMIT, Integer.toString(recentsLimit));
    }

    public boolean isRestartRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(RESTART_REQUIRES_CONFIRMATION, true);
    }

    public void setRestartRequiresConfirmation(boolean restartRequiresConfirmation) {
        this.myPropertiesComponent.setValue(RESTART_REQUIRES_CONFIRMATION, String.valueOf(restartRequiresConfirmation));
    }

    public boolean isStopIncompatibleRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, true);
    }

    public void setStopIncompatibleRequiresConfirmation(boolean stopIncompatibleRequiresConfirmation) {
        this.myPropertiesComponent.setValue(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, String.valueOf(stopIncompatibleRequiresConfirmation));
    }
}

