/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ProgramRunnerUtil");

    private ProgramRunnerUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(@NotNull String executorId, RunnerAndConfigurationSettings configuration) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ProgramRunnerUtil", "getRunner"));
        }
        return configuration == null ? null : RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull Project project, @Nullable DataContext context, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunContentDescriptor contentToReuse, boolean showSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executor.getId(), configuration);
        if (runner == null) {
            LOG.error("Runner MUST not be null! Cannot find runner for " + executor.getId() + " and " + configuration.getConfiguration().getFactory().getName());
            return;
        }
        ProgramRunnerUtil.executeConfiguration(project, context, configuration, executor, target, contentToReuse, showSettings, runner, null, true);
    }

    public static void executeConfiguration(Project project, DataContext context, @Nullable RunnerAndConfigurationSettings configuration, Executor executor, ExecutionTarget target, RunContentDescriptor contentToReuse, boolean showSettings, @NotNull ProgramRunner runner, @Nullable RunProfile runProfile, boolean assignNewId) {
        ConfigurationType configurationType;
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (ExecutorRegistry.getInstance().isStarting(project, executor.getId(), runner.getRunnerId())) {
            return;
        }
        if (configuration != null && !ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)configuration, (ExecutionTarget)target)) {
            ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (RunProfile)configuration.getConfiguration(), (ExecutionException)new ExecutionException(StringUtil.escapeXml((String)("Cannot run '" + configuration.getName() + "' on '" + target.getDisplayName() + "'"))));
            return;
        }
        if (configuration != null && (!RunManagerImpl.canRunConfiguration(configuration, executor) || showSettings && configuration.isEditBeforeRun())) {
            if (!RunDialog.editConfiguration(project, configuration, "Edit configuration", executor)) {
                return;
            }
            while (!RunManagerImpl.canRunConfiguration(configuration, executor) && 0 == Messages.showYesNoDialog((Project)project, (String)"Configuration is still incorrect. Do you want to edit it again?", (String)"Change Configuration Settings", (String)"Edit", (String)"Continue Anyway", (Icon)Messages.getErrorIcon())) {
                if (RunDialog.editConfiguration(project, configuration, "Edit configuration", executor)) continue;
                return;
            }
        }
        ConfigurationType configurationType2 = configurationType = configuration != null ? configuration.getType() : null;
        if (configurationType != null) {
            UsageTrigger.trigger("execute." + ConvertUsagesUtil.ensureProperKey(configurationType.getId()) + "." + executor.getId());
        }
        try {
            ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, executor);
            if (configuration != null) {
                builder.setRunnerAndSettings(runner, configuration);
            } else {
                builder.setRunnerId(runner.getRunnerId());
            }
            builder.setTarget(target).setContentToReuse(contentToReuse).setDataContext(context);
            if (assignNewId) {
                builder.assignNewId();
            }
            if (runProfile != null) {
                builder.setRunProfile(runProfile);
            }
            runner.execute(builder.build());
        }
        catch (ExecutionException e) {
            String name;
            String string = name = configuration != null ? configuration.getName() : null;
            if (name == null && runProfile != null) {
                name = runProfile.getName();
            }
            if (name == null && contentToReuse != null) {
                name = contentToReuse.getDisplayName();
            }
            if (name == null) {
                name = "<Unknown>";
            }
            ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (String)name, (ExecutionException)e);
        }
    }

    public static void executeConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        ProgramRunnerUtil.executeConfiguration(project, null, configuration, executor, ExecutionTargetManager.getActiveTarget((Project)project), null, true);
    }

    public static Icon getConfigurationIcon(RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon;
        RunConfiguration configuration = settings.getConfiguration();
        ConfigurationFactory factory = settings.getFactory();
        Icon icon2 = icon = factory != null ? factory.getIcon(configuration) : null;
        if (icon == null) {
            icon = AllIcons.RunConfigurations.Unknown;
        }
        Icon icon3 = configurationIcon = settings.isTemporary() ? IconLoader.getTransparentIcon((Icon)icon, (float)0.3f) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    public static String shortenName(String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        if (name.length() < symbols) {
            return name;
        }
        return name.substring(0, symbols) + "...";
    }
}

