/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorRegistryImpl
extends ExecutorRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ExecutorRegistryImpl");
    @NonNls
    public static final String RUNNERS_GROUP = "RunnerActions";
    @NonNls
    public static final String RUN_CONTEXT_GROUP = "RunContextGroup";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private ActionManager myActionManager;
    private final Map<String, Executor> myId2Executor = new HashMap();
    private final Set<String> myContextActionIdSet = new com.intellij.util.containers.HashSet();
    private final Map<String, AnAction> myId2Action = new HashMap();
    private final Map<String, AnAction> myContextActionId2Action = new HashMap();
    private final Set<Trinity<Project, String, String>> myInProgress = Collections.synchronizedSet(new HashSet());

    public ExecutorRegistryImpl(ActionManager actionManager) {
        this.myActionManager = actionManager;
    }

    synchronized void initExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl", "initExecutor"));
        }
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
        this.registerAction(executor.getId(), new ExecutorAction(executor), RUNNERS_GROUP, this.myId2Action);
        this.registerAction(executor.getContextActionId(), (AnAction)new RunContextAction(executor), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        AnAction action = this.myActionManager.getAction(actionId);
        if (action == null) {
            this.myActionManager.registerAction(actionId, anAction);
            map.put(actionId, anAction);
            action = anAction;
        }
        DefaultActionGroup group = (DefaultActionGroup)this.myActionManager.getAction(groupId);
        group.add(action);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl", "deinitExecutor"));
        }
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        this.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        this.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        DefaultActionGroup group = (DefaultActionGroup)this.myActionManager.getAction(groupId);
        if (group != null) {
            group.remove(this.myActionManager.getAction(actionId));
            AnAction action = map.get(actionId);
            if (action != null) {
                this.myActionManager.unregisterAction(actionId);
                map.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        Executor[] executorArray = this.myExecutors.toArray(new Executor[this.myExecutors.size()]);
        if (executorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutorRegistryImpl", "getRegisteredExecutors"));
        }
        return executorArray;
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExecutorRegistyImpl" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutorRegistryImpl", "getComponentName"));
        }
        return "ExecutorRegistyImpl";
    }

    public void initComponent() {
        Executor[] executors;
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(final Project project) {
                MessageBusConnection connect = project.getMessageBus().connect((Disposable)project);
                connect.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

                    public void processStartScheduled(String executorId, ExecutionEnvironment env) {
                        ExecutorRegistryImpl.this.myInProgress.add(ExecutorRegistryImpl.createExecutionId(executorId, env, project));
                    }

                    public void processNotStarted(String executorId, @NotNull ExecutionEnvironment env) {
                        if (env == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processNotStarted"));
                        }
                        ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, env, project));
                    }

                    public void processStarted(String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                        if (env == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processStarted"));
                        }
                        if (handler == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processStarted"));
                        }
                        ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, env, project));
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(Project project) {
                Set set = ExecutorRegistryImpl.this.myInProgress;
                synchronized (set) {
                    Iterator it = ExecutorRegistryImpl.this.myInProgress.iterator();
                    while (it.hasNext()) {
                        Trinity trinity = (Trinity)it.next();
                        if (!project.equals(trinity.first)) continue;
                        it.remove();
                    }
                }
            }
        });
        for (Executor executor : executors = (Executor[])Extensions.getExtensions((ExtensionPointName)Executor.EXECUTOR_EXTENSION_NAME)) {
            this.initExecutor(executor);
        }
    }

    private static Trinity<Project, String, String> createExecutionId(String executorId, ExecutionEnvironment env, Project project) {
        return new Trinity((Object)project, (Object)executorId, (Object)env.getRunnerId());
    }

    public boolean isStarting(Project project, String executorId, String runnerId) {
        return this.myInProgress.contains(new Trinity((Object)project, (Object)executorId, (Object)runnerId));
    }

    public synchronized void disposeComponent() {
        if (this.myExecutors.size() > 0) {
            ArrayList<Executor> executors = new ArrayList<Executor>(this.myExecutors);
            for (Executor executor : executors) {
                this.deinitExecutor(executor);
            }
            this.myExecutors = null;
        }
        this.myActionManager = null;
    }

    private class ExecutorAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecutorAction(Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction", "<init>"));
            }
            super(executor.getStartActionText(), executor.getDescription(), executor.getIcon());
            this.myExecutor = executor;
        }

        public void update(AnActionEvent e) {
            String text;
            Presentation presentation = e.getPresentation();
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null || !project.isInitialized() || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedConfiguration = this.getConfiguration(project);
            boolean enabled = false;
            String textWithMnemonic = this.getTemplatePresentation().getTextWithMnemonic();
            if (selectedConfiguration != null) {
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)selectedConfiguration.getConfiguration());
                ExecutionTarget target = ExecutionTargetManager.getActiveTarget((Project)project);
                boolean bl = enabled = ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)selectedConfiguration, (ExecutionTarget)target) && runner != null && !ExecutorRegistryImpl.this.isStarting(project, this.myExecutor.getId(), runner.getRunnerId());
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
                text = this.myExecutor.getStartActionText(selectedConfiguration.getName());
            } else {
                text = textWithMnemonic;
            }
            presentation.setEnabled(enabled);
            presentation.setText(text);
        }

        @Nullable
        private RunnerAndConfigurationSettings getConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction", "getConfiguration"));
            }
            return RunManagerEx.getInstanceEx(project).getSelectedConfiguration();
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext dataContext = e.getDataContext();
            Project project = e.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            RunnerAndConfigurationSettings configuration = this.getConfiguration(project);
            if (configuration == null) {
                return;
            }
            ExecutionTarget target = ExecutionTargetManager.getActiveTarget((Project)project);
            ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, this.myExecutor);
            ProgramRunner runner = ProgramRunnerUtil.getRunner(this.myExecutor.getId(), configuration);
            if (runner == null) {
                return;
            }
            builder.setDataContext(dataContext).setTarget(target).setRunnerAndSettings(runner, configuration);
            ExecutionManager.getInstance((Project)project).restartRunProfile(runner, builder.build(), null);
        }
    }
}

