/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.process.ProcessListener;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionMode {
    private final boolean myCancelable;
    private final String myTitle;
    private final String myTitle2;
    private final boolean myRunWithModal;
    private final boolean myRunInBG;
    private final JComponent myProgressParentComponent;
    private Function<Object, Boolean> myShouldCancelFun;
    private final Object CANCEL_FUN_LOCK = new Object();
    private final List<ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ExecutionMode(boolean cancelable, @Nullable String title, @Nullable String title2, boolean runInBG, boolean runWithModal, JComponent progressParentComponent) {
        this.myCancelable = cancelable;
        this.myTitle = title;
        this.myTitle2 = title2;
        this.myRunInBG = runInBG;
        this.myRunWithModal = runWithModal;
        this.myProgressParentComponent = progressParentComponent;
    }

    public int getTimeout() {
        return -1;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitle2() {
        return this.myTitle2;
    }

    public boolean cancelable() {
        return this.myCancelable;
    }

    public boolean inBackGround() {
        return this.myRunInBG;
    }

    public boolean withModalProgress() {
        return this.myRunWithModal;
    }

    public JComponent getProgressParentComponent() {
        return this.myProgressParentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Function<Object, Boolean> shouldCancelFun() {
        Object object = this.CANCEL_FUN_LOCK;
        synchronized (object) {
            return this.myShouldCancelFun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldCancelFun(Function<Object, Boolean> shouldCancelFun) {
        Object object = this.CANCEL_FUN_LOCK;
        synchronized (object) {
            this.myShouldCancelFun = shouldCancelFun;
        }
    }

    public void addProcessListener(@NotNull ProcessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ExecutionMode", "addProcessListener"));
        }
        this.myListeners.add(listener);
    }

    @NotNull
    public List<ProcessListener> getProcessListeners() {
        List<ProcessListener> list = this.myListeners;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionMode", "getProcessListeners"));
        }
        return list;
    }
}

