/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchActionGroupPopup
extends PopupFactoryImpl.ActionGroupPopup {
    public BranchActionGroupPopup(@NotNull String title, @NotNull Project project, @NotNull Condition<AnAction> preselectActionCondition, @NotNull ActionGroup actions) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        super(title, actions, SimpleDataContext.getProjectContext(project), false, false, false, true, null, -1, preselectActionCondition, null);
    }

    @Override
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        WizardPopup popup = super.createPopup(parent, step, parentValue);
        RootAction rootAction = BranchActionGroupPopup.getRootAction(parentValue);
        if (rootAction != null) {
            popup.setAdText(rootAction.getCaption());
        }
        return popup;
    }

    @Nullable
    private static RootAction getRootAction(Object value) {
        AnAction action;
        if (value instanceof PopupFactoryImpl.ActionItem && (action = ((PopupFactoryImpl.ActionItem)value).getAction()) instanceof RootAction) {
            return (RootAction)action;
        }
        return null;
    }

    @Override
    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this){
            private ErrorLabel myBranchLabel;

            @Override
            protected void customizeComponent(JList list, Object value, boolean isSelected) {
                super.customizeComponent(list, value, isSelected);
                RootAction rootAction = BranchActionGroupPopup.getRootAction(value);
                if (rootAction != null) {
                    this.myBranchLabel.setVisible(true);
                    this.myBranchLabel.setText(String.format("[%s]", rootAction.getDisplayableBranchText()));
                    if (isSelected) {
                        this.setSelected((JComponent)this.myBranchLabel);
                    } else {
                        this.myBranchLabel.setBackground(this.getBackground());
                        this.myBranchLabel.setForeground((Color)JBColor.GRAY);
                    }
                    1.adjustOpacity((JComponent)this.myBranchLabel, (boolean)isSelected);
                } else {
                    this.myBranchLabel.setVisible(false);
                }
            }

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.myBranchLabel = new ErrorLabel();
                this.myBranchLabel.setOpaque(true);
                this.myBranchLabel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
                OpaquePanel compoundPanel = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
                compoundPanel.add((Component)this.myTextLabel, "Center");
                compoundPanel.add((Component)this.myBranchLabel, "East");
                return this.layoutComponent((JComponent)compoundPanel);
            }
        };
    }
}

