/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RepositoryImpl
implements Repository,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRootDir;
    @NotNull
    protected volatile Repository.State myState;
    @Nullable
    protected volatile String myCurrentRevision;

    protected RepositoryImpl(@NotNull Project project, @NotNull VirtualFile dir, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        this.myProject = project;
        this.myRootDir = dir;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getRoot"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string = this.getRoot().getPresentableUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getPresentableUrl"));
        }
        return string;
    }

    public String toString() {
        return this.getPresentableUrl();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getState"));
        }
        return state;
    }

    @Override
    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (!this.getProject().equals(that.getProject())) {
            return false;
        }
        return this.getRoot().equals(that.getRoot());
    }

    public int hashCode() {
        int result = this.getProject().hashCode();
        result = 31 * result + this.getRoot().hashCode();
        return result;
    }
}

