/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class LogConsoleManagerBase
implements LogConsoleManager,
Disposable {
    private final Project myProject;
    private final Map<AdditionalTabComponent, Content> myAdditionalContent;
    private ExecutionEnvironment myEnvironment;
    private final GlobalSearchScope mySearchScope;

    protected LogConsoleManagerBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "<init>"));
        }
        this(project, GlobalSearchScope.allScope((Project)project));
    }

    protected LogConsoleManagerBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "<init>"));
        }
        this.myAdditionalContent = new HashMap<AdditionalTabComponent, Content>();
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public void setEnvironment(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "setEnvironment"));
        }
        this.myEnvironment = env;
    }

    protected final ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @Override
    public void addLogConsole(String name, String path, @NotNull Charset charset, long skippedContent) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        this.addLogConsole(name, path, charset, skippedContent, this.getDefaultIcon());
    }

    /*
     * WARNING - void declaration
     */
    public void addLogConsole(String name, final String path, @NotNull Charset charset, long skippedContent, Icon icon) {
        void icon2;
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/diagnostic/logging/LogConsoleManagerBase", "addLogConsole"));
        }
        this.doAddLogConsole(new LogConsoleImpl(this.myProject, new File(path), charset, skippedContent, name, false, this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(path);
            }
        }, path, (Icon)icon2);
    }

    @Override
    public void addLogConsole(String name, Reader reader, String id) {
        this.addLogConsole(name, reader, id, this.getDefaultIcon());
    }

    public void addLogConsole(String name, Reader reader, final String id, Icon icon) {
        this.doAddLogConsole(new LogConsoleBase(this.myProject, reader, name, false, new DefaultLogFilterModel(this.myProject), this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(id);
            }
        }, id, icon);
    }

    private void doAddLogConsole(final LogConsoleBase log, String id, Icon icon) {
        if (this.myEnvironment != null && this.myEnvironment.getRunProfile() instanceof RunConfigurationBase) {
            ((RunConfigurationBase)this.myEnvironment.getRunProfile()).customizeLogConsole((LogConsole)log);
        }
        log.attachStopLogConsoleTrackingListener(this.getProcessHandler());
        this.addAdditionalTabComponent(log, id, icon);
        this.getUi().addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                log.activate();
            }
        }, (Disposable)log);
    }

    private boolean isConsoleActive(String id) {
        Content content = this.getUi().findContent(id);
        return content != null && content.isSelected();
    }

    @Override
    public void removeLogConsole(String path) {
        Content content = this.getUi().findContent(path);
        if (content != null) {
            LogConsoleBase log = (LogConsoleBase)((Object)content.getComponent());
            this.removeAdditionalTabComponent(log);
        }
    }

    public void addAdditionalTabComponent(AdditionalTabComponent tabComponent, String id) {
        this.addAdditionalTabComponent(tabComponent, id, this.getDefaultIcon());
    }

    public Content addAdditionalTabComponent(AdditionalTabComponent tabComponent, String id, Icon icon) {
        Content logContent = this.createLogContent(tabComponent, id, icon);
        this.myAdditionalContent.put(tabComponent, logContent);
        this.getUi().addContent(logContent);
        return logContent;
    }

    protected Content createLogContent(AdditionalTabComponent tabComponent, String id, Icon icon) {
        return this.getUi().createContent(id, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), icon, tabComponent.getPreferredFocusableComponent());
    }

    public void removeAdditionalTabComponent(AdditionalTabComponent component) {
        Disposer.dispose((Disposable)component);
        Content content = this.myAdditionalContent.remove(component);
        if (!this.getUi().isDisposed()) {
            this.getUi().removeContent(content, true);
        }
    }

    public void dispose() {
        for (AdditionalTabComponent component : (AdditionalTabComponent[])ArrayUtil.toObjectArray(this.myAdditionalContent.keySet(), AdditionalTabComponent.class)) {
            this.removeAdditionalTabComponent(component);
        }
    }

    protected abstract Icon getDefaultIcon();

    protected abstract RunnerLayoutUi getUi();

    public abstract ProcessHandler getProcessHandler();
}

