/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LogEventException;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jetbrains.annotations.NotNull;

public class DialogAppender
extends AppenderSkeleton {
    private static final ErrorLogger DEFAULT_LOGGER = new DefaultIdeaErrorLogger();
    private static final int MAX_ASYNC_LOGGING_EVENTS = 5;
    private volatile Runnable myDialogRunnable = null;
    private final AtomicInteger myPendingAppendCounts = new AtomicInteger();

    protected synchronized void append(final @NotNull LoggingEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/diagnostic/DialogAppender", "append"));
        }
        if (!event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) || Main.isCommandLine() || !IdeaApplication.isLoaded()) {
            return;
        }
        Runnable action = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArrayList<ErrorLogger> loggers = new ArrayList<ErrorLogger>();
                    loggers.add(DEFAULT_LOGGER);
                    Application application = ApplicationManager.getApplication();
                    if (application != null) {
                        if (application.isHeadlessEnvironment() || application.isDisposed()) {
                            return;
                        }
                        ContainerUtil.addAll(loggers, (Object[])application.getComponents(ErrorLogger.class));
                    }
                    DialogAppender.this.appendToLoggers(event, loggers.toArray(new ErrorLogger[loggers.size()]));
                }
                finally {
                    DialogAppender.this.myPendingAppendCounts.decrementAndGet();
                }
            }
        };
        if (this.myPendingAppendCounts.addAndGet(1) > 5) {
            this.myPendingAppendCounts.decrementAndGet();
        } else {
            SwingUtilities.invokeLater(action);
        }
    }

    void appendToLoggers(@NotNull LoggingEvent event, @NotNull ErrorLogger[] errorLoggers) {
        IdeaLoggingEvent ideaEvent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (errorLoggers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (this.myDialogRunnable != null) {
            return;
        }
        Object message = event.getMessage();
        if (message instanceof IdeaLoggingEvent) {
            ideaEvent = (IdeaLoggingEvent)message;
        } else {
            ThrowableInformation info = event.getThrowableInformation();
            if (info == null) {
                return;
            }
            Throwable throwable = info.getThrowable();
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)throwable);
            ideaEvent = rootCause instanceof LogEventException ? ((LogEventException)rootCause).getLogMessage() : new IdeaLoggingEvent(message == null ? "<null> " : message.toString(), throwable);
        }
        for (int i = errorLoggers.length - 1; i >= 0; --i) {
            final ErrorLogger logger = errorLoggers[i];
            if (!logger.canHandle(ideaEvent)) continue;
            this.myDialogRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        logger.handle(ideaEvent);
                    }
                    finally {
                        DialogAppender.this.myDialogRunnable = null;
                    }
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                new Thread(this.myDialogRunnable).start();
                break;
            }
            app.executeOnPooledThread(this.myDialogRunnable);
            break;
        }
    }

    Runnable getDialogRunnable() {
        return this.myDialogRunnable;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }
}

