/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render.configurables;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ClassLabelExpressionConfigurable
implements UnnamedConfigurable {
    private final LabelRenderer myRenderer;
    private LabeledComponent<CompletionEditor> myCompletionEditor;
    private final JPanel myPanel;

    public ClassLabelExpressionConfigurable(@NotNull Project project, LabelRenderer renderer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/tree/render/configurables/ClassLabelExpressionConfigurable", "<init>"));
        }
        this.myRenderer = renderer;
        this.myCompletionEditor = new LabeledComponent();
        PsiClass psiClass = DebuggerUtils.findClass((String)this.myRenderer.getClassName(), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        this.myCompletionEditor.setComponent((JComponent)((DebuggerUtilsEx)DebuggerUtils.getInstance()).createEditor(project, (PsiElement)psiClass, "ClassLabelExpression"));
        this.myCompletionEditor.setText(DebuggerBundle.message((String)"label.class.label.expression.configurable.node.label", (Object[])new Object[0]));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myCompletionEditor, "North");
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !this.myRenderer.getLabelExpression().equals(((CompletionEditor)this.myCompletionEditor.getComponent()).getText());
    }

    public void apply() throws ConfigurationException {
        this.myRenderer.setLabelExpression(((CompletionEditor)this.myCompletionEditor.getComponent()).getText());
    }

    public void reset() {
        ((CompletionEditor)this.myCompletionEditor.getComponent()).setText(this.myRenderer.getLabelExpression());
    }

    public void disposeUIResources() {
        if (this.myCompletionEditor != null) {
            ((CompletionEditor)this.myCompletionEditor.getComponent()).dispose();
            this.myCompletionEditor = null;
        }
    }
}

