/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.Enumeration;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class WatchDebuggerTree
extends DebuggerTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.WatchDebuggerTree");

    public WatchDebuggerTree(Project project) {
        super(project);
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
    }

    public DebuggerTreeNodeImpl[] getWatches() {
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        DebuggerTreeNodeImpl[] watches = new DebuggerTreeNodeImpl[root.getChildCount()];
        Enumeration e = root.children();
        int i = 0;
        while (e.hasMoreElements()) {
            watches[i++] = (DebuggerTreeNodeImpl)e.nextElement();
        }
        return watches;
    }

    public int getWatchCount() {
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        return root != null ? root.getChildCount() : 0;
    }

    public DebuggerTreeNodeImpl addWatch(WatchItemDescriptor descriptor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        WatchItemDescriptor watchDescriptor = new WatchItemDescriptor(this.getProject(), descriptor.getEvaluationText());
        watchDescriptor.displayAs(descriptor);
        DebuggerTreeNodeImpl node = DebuggerTreeNodeImpl.createNodeNoUpdate(this, watchDescriptor);
        root.add(node);
        this.treeChanged();
        this.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
        return node;
    }

    public DebuggerTreeNodeImpl addWatch(TextWithImports text, @Nullable String customName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        WatchItemDescriptor descriptor = new WatchItemDescriptor(this.getProject(), text, customName);
        DebuggerTreeNodeImpl node = DebuggerTreeNodeImpl.createNodeNoUpdate(this, descriptor);
        root.add(node);
        this.treeChanged();
        TreePath path = new TreePath(node.getPath());
        this.getSelectionModel().setSelectionPath(path);
        this.scrollPathToVisible(path);
        return node;
    }

    public void removeWatch(DebuggerTreeNodeImpl node) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(node.getDescriptor() instanceof WatchItemDescriptor);
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        DebuggerTreeNodeImpl nodeToSelect = (DebuggerTreeNodeImpl)node.getNextSibling();
        this.getMutableModel().removeNodeFromParent(node);
        this.treeChanged();
        if (nodeToSelect == null && root.getChildCount() > 0) {
            nodeToSelect = (DebuggerTreeNodeImpl)root.getChildAt(root.getChildCount() - 1);
        }
        if (nodeToSelect != null) {
            this.setSelectionPath(new TreePath(nodeToSelect.getPath()));
        }
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        for (DebuggerTreeNodeImpl node : this.getWatches()) {
            node.calcValue();
        }
    }

    public static void setWatchNodeText(DebuggerTreeNodeImpl node, TextWithImports text) {
        ((WatchItemDescriptor)node.getDescriptor()).setEvaluationText(text);
        node.calcValue();
    }
}

