/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.FrameVariablesTree;
import com.intellij.debugger.ui.impl.ValueNodeDnD;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.SystemProperties;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariablesPanel
extends DebuggerTreePanel
implements DataProvider {
    @NonNls
    private static final String HELP_ID = "debugging.debugFrame";
    private static final String TREE = "tree";
    private static final String X_TREE = "xTree";
    private final JPanel myCards;
    private final MyXVariablesView myXTree;

    public VariablesPanel(Project project, DebuggerStateManager stateManager, Disposable parent) {
        super(project, stateManager);
        this.setBorder(null);
        FrameVariablesTree frameTree = this.getFrameTree();
        this.myCards = new JPanel(new CardLayout());
        this.myCards.add((Component)((Object)frameTree), TREE);
        this.myXTree = new MyXVariablesView(project);
        this.registerDisposable(this.myXTree);
        this.myCards.add((Component)((Object)this.myXTree.getTree()), X_TREE);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myCards);
        pane.getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)pane, "Center");
        this.registerDisposable(DebuggerAction.installEditAction((JTree)((Object)frameTree), "Debugger.EditNodeSource"));
        this.overrideShortcut((JComponent)((Object)frameTree), "Debugger.CopyValue", CommonShortcuts.getCopy());
        this.overrideShortcut((JComponent)((Object)frameTree), "Debugger.SetValue", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)));
        new ValueNodeDnD(this.myTree, parent);
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new FrameVariablesTree(this.getProject(), SystemProperties.getBooleanProperty((String)"java.debugger.xTree", (boolean)true) ? this : null);
    }

    @Override
    protected void changeEvent(DebuggerContextImpl newContext, int event) {
        if (event != 12) {
            super.changeEvent(newContext, event);
        }
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.FramePanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.FramePanelPopup", group);
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    public FrameVariablesTree getFrameTree() {
        return (FrameVariablesTree)this.getTree();
    }

    public void stackChanged(final @Nullable XStackFrame xStackFrame) {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                VariablesPanel.this.myXTree.stackChanged(xStackFrame);
                ((CardLayout)VariablesPanel.this.myCards.getLayout()).show(VariablesPanel.this.myCards, xStackFrame == null ? VariablesPanel.TREE : VariablesPanel.X_TREE);
            }
        });
    }

    private static final class MyXVariablesView
    extends XVariablesViewBase {
        private XStackFrame myCurrentXStackFrame;

        public MyXVariablesView(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/impl/VariablesPanel$MyXVariablesView", "<init>"));
            }
            super(project, new XDebuggerEditorsProvider(){

                @NotNull
                public FileType getFileType() {
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/impl/VariablesPanel$MyXVariablesView$1", "createDocument"));
                    }
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/impl/VariablesPanel$MyXVariablesView$1", "createDocument"));
                    }
                    if (mode == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/debugger/ui/impl/VariablesPanel$MyXVariablesView$1", "createDocument"));
                    }
                    throw new UnsupportedOperationException();
                }
            }, null);
        }

        public void stackChanged(@Nullable XStackFrame stackFrame) {
            if (this.myCurrentXStackFrame != null) {
                this.saveCurrentTreeState(stackFrame);
            }
            this.myCurrentXStackFrame = stackFrame;
            if (stackFrame == null) {
                this.getTree().setSourcePosition(null);
            } else {
                this.buildTreeAndRestoreState(stackFrame);
            }
        }
    }
}

