/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.AddToWatchActionHandler;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.WatchPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeInplaceEditor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DropActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class MainWatchPanel
extends WatchPanel
implements DataProvider {
    public MainWatchPanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        final WatchDebuggerTree watchTree = this.getWatchTree();
        AnAction removeWatchesAction = ActionManager.getInstance().getAction("Debugger.RemoveWatch");
        removeWatchesAction.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)watchTree));
        AnAction newWatchAction = ActionManager.getInstance().getAction("Debugger.NewWatch");
        newWatchAction.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)watchTree));
        DoubleClickListener mouseListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                AnAction editWatchAction = ActionManager.getInstance().getAction("Debugger.EditWatch");
                Presentation presentation = editWatchAction.getTemplatePresentation().clone();
                DataContext context = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                AnActionEvent actionEvent = new AnActionEvent(null, context, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                editWatchAction.actionPerformed(actionEvent);
                return true;
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseListener);
        AnAction editWatchAction = ActionManager.getInstance().getAction("Debugger.EditWatch");
        editWatchAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)watchTree));
        this.registerDisposable(new Disposable((ClickListener)mouseListener, removeWatchesAction, newWatchAction, editWatchAction){
            final /* synthetic */ ClickListener val$mouseListener;
            final /* synthetic */ AnAction val$removeWatchesAction;
            final /* synthetic */ AnAction val$newWatchAction;
            final /* synthetic */ AnAction val$editWatchAction;
            {
                this.val$mouseListener = clickListener;
                this.val$removeWatchesAction = anAction;
                this.val$newWatchAction = anAction2;
                this.val$editWatchAction = anAction3;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), this.val$mouseListener);
                this.val$removeWatchesAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                this.val$newWatchAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                this.val$editWatchAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
            }
        });
        DnDManager.getInstance().registerTarget((DnDTarget)new DnDNativeTarget(){

            public boolean update(DnDEvent aEvent) {
                DnDNativeTarget.EventInfo info;
                String text;
                Object object = aEvent.getAttachedObject();
                if (object == null) {
                    return true;
                }
                String add = DebuggerBundle.message((String)"watchs.add.text", (Object[])new Object[0]);
                if (object.getClass().isArray()) {
                    Class<?> type = object.getClass().getComponentType();
                    if (DebuggerTreeNodeImpl.class.isAssignableFrom(type)) {
                        aEvent.setHighlighting((Component)((Object)MainWatchPanel.this.myTree), 17);
                        aEvent.setDropPossible(add, new DropActionHandler(){

                            public void performDrop(DnDEvent aEvent) {
                                MainWatchPanel.this.addWatchesFrom((DebuggerTreeNodeImpl[])aEvent.getAttachedObject());
                            }
                        });
                    }
                } else if (object instanceof DnDNativeTarget.EventInfo && (text = (info = (DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
                    aEvent.setHighlighting((Component)((Object)MainWatchPanel.this.myTree), 17);
                    aEvent.setDropPossible(add, new DropActionHandler(){

                        public void performDrop(DnDEvent aEvent) {
                            MainWatchPanel.this.addWatchesFrom(text);
                        }
                    });
                }
                return true;
            }

            public void drop(DnDEvent aEvent) {
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        }, (JComponent)((Object)this.myTree));
    }

    private void addWatchesFrom(DebuggerTreeNodeImpl[] nodes) {
        AddToWatchActionHandler.addFromNodes(this.getContext(), this, nodes);
    }

    private void addWatchesFrom(String text) {
        AddToWatchActionHandler.doAddWatch(this, new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text), null);
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.WatchesPanelPopup");
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("Debugger.WatchesPanelPopup", group);
        return popupMenu;
    }

    public void newWatch() {
        DebuggerTreeNodeImpl node = this.getWatchTree().addWatch(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ""), null);
        this.editNode(node);
    }

    public void editNode(final DebuggerTreeNodeImpl node) {
        DebuggerContextImpl context = this.getContext();
        final DebuggerExpressionComboBox comboBox = new DebuggerExpressionComboBox(this.getProject(), PositionUtil.getContextElement((StackFrameContext)context), "evaluation", DefaultCodeFragmentFactory.getInstance());
        comboBox.setText(((WatchItemDescriptor)node.getDescriptor()).getEvaluationText());
        comboBox.selectAll();
        DebuggerTreeInplaceEditor editor = new DebuggerTreeInplaceEditor(node){

            @Override
            public JComponent createInplaceEditorComponent() {
                return comboBox;
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return comboBox.getPreferredFocusedComponent();
            }

            @Override
            public Editor getEditor() {
                return comboBox.getEditor();
            }

            @Override
            public JComponent getEditorComponent() {
                return comboBox.getEditorComponent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doOKAction() {
                TextWithImports text;
                if (comboBox.isPopupVisible()) {
                    comboBox.selectPopupValue();
                }
                if (!(text = comboBox.getText()).isEmpty()) {
                    WatchDebuggerTree.setWatchNodeText(node, text);
                    comboBox.addRecent(text);
                } else {
                    MainWatchPanel.this.getWatchTree().removeWatch(node);
                }
                try {
                    super.doOKAction();
                }
                finally {
                    comboBox.dispose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelEditing() {
                comboBox.setPopupVisible(false);
                if (((WatchItemDescriptor)node.getDescriptor()).getEvaluationText().isEmpty()) {
                    MainWatchPanel.this.getWatchTree().removeWatch(node);
                }
                try {
                    super.cancelEditing();
                }
                finally {
                    comboBox.dispose();
                }
            }
        };
        editor.show();
    }

    @Override
    protected JComponent createTreePanel(final WatchDebuggerTree tree) {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)tree));
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                MainWatchPanel.executeAction("Debugger.NewWatch", tree);
            }
        });
        if (!SystemInfo.isMac) {
            decorator.addExtraAction(AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("Debugger.AddToWatch")));
        }
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                MainWatchPanel.executeAction("Debugger.RemoveWatch", tree);
            }
        });
        CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, SystemInfo.isMac ? 1 : 0, 0, SystemInfo.isMac ? 0 : 1, 0);
        decorator.setToolbarBorder((Border)border);
        JPanel panel = decorator.createPanel();
        panel.setBorder(null);
        return panel;
    }

    private static void executeAction(String watch, WatchDebuggerTree tree) {
        AnAction action = ActionManager.getInstance().getAction(watch);
        Presentation presentation = action.getTemplatePresentation().clone();
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)tree));
        AnActionEvent actionEvent = new AnActionEvent(null, context, "DebuggerToolbar", presentation, ActionManager.getInstance(), 0);
        action.actionPerformed(actionEvent);
    }
}

