/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes DEFAULT_ATTRIBUTES = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes SPECIAL_NODE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    private static final SimpleTextAttributes OBJECT_ID_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)value;
        if (node != null) {
            SimpleColoredText text = node.getText();
            if (text != null) {
                text.appendToComponent((ColoredTextContainer)this);
            }
            this.setIcon(node.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptorImpl descriptor) {
        Icon nodeIcon = null;
        if (descriptor instanceof ThreadGroupDescriptorImpl) {
            nodeIcon = ((ThreadGroupDescriptorImpl)descriptor).isCurrent() ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup;
        } else if (descriptor instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)descriptor;
            nodeIcon = threadDescriptor.getIcon();
        } else if (descriptor instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)descriptor;
            nodeIcon = stackDescriptor.getIcon();
        } else if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            nodeIcon = valueDescriptor instanceof FieldDescriptorImpl && ((FieldDescriptorImpl)valueDescriptor).isStatic() ? PlatformIcons.FIELD_ICON : (valueDescriptor.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptor.isPrimitive() ? AllIcons.Debugger.Db_primitive : (valueDescriptor instanceof WatchItemDescriptor ? AllIcons.Debugger.Watch : AllIcons.Debugger.Value)));
            Icon valueIcon = valueDescriptor.getValueIcon();
            if (nodeIcon != null && valueIcon != null) {
                RowIcon composite = new RowIcon(2);
                composite.setIcon(nodeIcon, 0);
                composite.setIcon(valueIcon, 1);
                nodeIcon = composite;
            }
        } else if (descriptor instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)descriptor;
            if (messageDescriptor.getKind() == 0) {
                nodeIcon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 2) {
                nodeIcon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 3) {
                nodeIcon = null;
            }
        } else if (descriptor instanceof StaticDescriptorImpl) {
            nodeIcon = AllIcons.Nodes.Static;
        }
        return nodeIcon;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component) {
        EditorColorsScheme scheme;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (component != null && ColorUtil.isDark((Color)component.getBackground()) != ColorUtil.isDark((Color)globalScheme.getDefaultBackground()) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            EditorColorsScheme editorColorsScheme = scheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "getColorScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = globalScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, EditorColorsScheme colorsScheme, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, colorsScheme, multiline, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, DebuggerTreeRenderer.getColorScheme(null), multiline, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, DebuggerTreeRenderer.getColorScheme(null), false, false);
    }

    private static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, EditorColorsScheme colorScheme, boolean multiline, boolean appendValue) {
        String[] strings;
        ValueMarkup markup;
        String nodeName;
        String text;
        SimpleColoredText descriptorText = new SimpleColoredText();
        if (descriptor == null) {
            text = "";
            nodeName = null;
        } else {
            text = descriptor.getLabel();
            nodeName = descriptor.getName();
        }
        if (text.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
            descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return descriptorText;
        }
        if (descriptor instanceof ValueDescriptor && (markup = ((ValueDescriptor)((Object)descriptor)).getMarkup(debuggerContext.getDebugProcess())) != null) {
            descriptorText.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        if ((strings = DebuggerTreeRenderer.breakString(text, nodeName))[0] != null) {
            if (descriptor instanceof MessageDescriptor && ((MessageDescriptor)descriptor).getKind() == 3) {
                descriptorText.append(strings[0], SPECIAL_NODE_ATTRIBUTES);
            } else {
                descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
            }
        }
        if (strings[1] != null) {
            descriptorText.append(strings[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (strings[2] != null) {
            if (descriptor instanceof ValueDescriptorImpl) {
                ValueDescriptorImpl valueDescriptor;
                String valueLabel;
                if (multiline && strings[2].indexOf(10) >= 0 && (strings = DebuggerTreeRenderer.breakString(strings[2], "="))[2] != null) {
                    strings[2] = strings[0] + strings[1] + "\n" + strings[2];
                }
                if ((strings = DebuggerTreeRenderer.breakString(strings[2], valueLabel = (valueDescriptor = (ValueDescriptorImpl)descriptor).getValueLabel()))[0] != null) {
                    descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
                }
                if (appendValue && strings[1] != null) {
                    SimpleTextAttributes valueLabelAttribs;
                    if (valueLabel != null && StringUtil.startsWithChar((CharSequence)valueLabel, (char)'{') && valueLabel.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)valueLabel, (char)'}')) {
                        int idx = valueLabel.indexOf(125);
                        String objectId = valueLabel.substring(0, idx + 1);
                        valueLabel = valueLabel.substring(idx + 1);
                        descriptorText.append(objectId, OBJECT_ID_HIGHLIGHT_ATTRIBUTES);
                    }
                    valueLabel = DebuggerUtilsEx.truncateString(valueLabel);
                    if (valueDescriptor.isDirty()) {
                        valueLabelAttribs = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                    } else {
                        TextAttributes attributes = null;
                        if (valueDescriptor.isNull()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                        } else if (valueDescriptor.isString()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.STRING);
                        }
                        valueLabelAttribs = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : DEFAULT_ATTRIBUTES;
                    }
                    EvaluateException exception = descriptor.getEvaluateException();
                    if (exception != null) {
                        String errorMessage = exception.getMessage();
                        if (valueLabel.endsWith(errorMessage)) {
                            DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel.substring(0, valueLabel.length() - errorMessage.length()), valueLabelAttribs, colorScheme);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        } else {
                            DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel, valueLabelAttribs, colorScheme);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        }
                    } else if (valueLabel.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                        descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel, valueLabelAttribs, colorScheme);
                    }
                }
            } else {
                descriptorText.append(strings[2], DEFAULT_ATTRIBUTES);
            }
        }
        return descriptorText;
    }

    private static void appendValueTextWithEscapesRendering(SimpleColoredText descriptorText, String valueText, SimpleTextAttributes attribs, EditorColorsScheme colorScheme) {
        SimpleTextAttributes escapeAttribs = null;
        StringBuilder buf = new StringBuilder();
        boolean slashFound = false;
        for (int idx = 0; idx < valueText.length(); ++idx) {
            char ch = valueText.charAt(idx);
            if (slashFound) {
                slashFound = false;
                if (ch == '\\' || ch == '\"' || ch == 'b' || ch == 't' || ch == 'n' || ch == 'f' || ch == 'r') {
                    if (buf.length() > 0) {
                        descriptorText.append(buf.toString(), attribs);
                        buf.setLength(0);
                    }
                    if (escapeAttribs == null) {
                        TextAttributes fromHighlighter = colorScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                        escapeAttribs = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : DEFAULT_ATTRIBUTES.derive(1, (Color)JBColor.GRAY, null, null);
                    }
                    if (ch != '\\' && ch != '\"') {
                        descriptorText.append("\\", escapeAttribs);
                    }
                    descriptorText.append(String.valueOf(ch), escapeAttribs);
                    continue;
                }
                buf.append('\\').append(ch);
                continue;
            }
            if (ch == '\\') {
                slashFound = true;
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            descriptorText.append(buf.toString(), attribs);
        }
    }

    private static String[] breakString(String source, String substr) {
        if (substr != null && substr.length() > 0) {
            int index = Math.max(source.indexOf(substr), 0);
            String prefix = index > 0 ? source.substring(0, index) : null;
            String suffix = (index += substr.length()) < source.length() - 1 ? source.substring(index) : null;
            return new String[]{prefix, substr, suffix};
        }
        return new String[]{source, null, null};
    }
}

