/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.WatchpointRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class FieldBreakpoint
extends BreakpointWithHighlighter<JavaFieldBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.FieldBreakpoint");
    private boolean myIsStatic;
    @NonNls
    public static final Key<FieldBreakpoint> CATEGORY = BreakpointCategory.lookup("field_breakpoints");

    protected FieldBreakpoint(Project project, XBreakpoint breakpoint) {
        super(project, breakpoint);
    }

    private FieldBreakpoint(Project project, @NotNull String fieldName, XBreakpoint breakpoint) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/breakpoints/FieldBreakpoint", "<init>"));
        }
        super(project, breakpoint);
        this.setFieldName(fieldName);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public String getFieldName() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? AllIcons.Debugger.Db_muted_disabled_field_breakpoint : AllIcons.Debugger.Db_muted_dep_field_breakpoint;
        }
        return master == null ? AllIcons.Debugger.Db_disabled_field_breakpoint : AllIcons.Debugger.Db_dep_field_breakpoint;
    }

    @Override
    protected Icon getSetIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_field_breakpoint : AllIcons.Debugger.Db_field_breakpoint;
    }

    @Override
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_invalid_field_breakpoint : AllIcons.Debugger.Db_invalid_field_breakpoint;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_verified_field_breakpoint : AllIcons.Debugger.Db_verified_field_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_field_warning_breakpoint : AllIcons.Debugger.Db_field_warning_breakpoint;
    }

    @Override
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiField getPsiField() {
        final SourcePosition sourcePosition = this.getSourcePosition();
        PsiField field = (PsiField)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField>(){

            public PsiField compute() {
                PsiClass psiClass = BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
                return psiClass != null ? psiClass.findFieldByName(FieldBreakpoint.this.getFieldName(), true) : null;
            }
        });
        if (field != null) {
            return field;
        }
        return PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, sourcePosition);
    }

    @Override
    protected void reload(PsiFile psiFile) {
        super.reload(psiFile);
        PsiField field = PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, this.getSourcePosition());
        if (field != null) {
            this.setFieldName(field.getName());
            PsiClass psiClass = field.getContainingClass();
            if (psiClass != null) {
                ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myClassName = psiClass.getQualifiedName();
            }
            this.myIsStatic = field.hasModifierProperty("static");
        }
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    @Override
    public boolean moveTo(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/FieldBreakpoint", "moveTo"));
        }
        PsiField field = PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, position);
        return field != null && super.moveTo(SourcePosition.createFromElement((PsiElement)field));
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        AccessWatchpointEvent accessEvent;
        ObjectReference reference;
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationEvent = (ModificationWatchpointEvent)event;
            ObjectReference reference2 = modificationEvent.object();
            if (reference2 != null) {
                return reference2;
            }
        } else if (event instanceof AccessWatchpointEvent && (reference = (accessEvent = (AccessWatchpointEvent)event).object()) != null) {
            return reference;
        }
        return super.getThisObject(context, event);
    }

    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType refType) {
        VirtualMachineProxyImpl vm = debugProcess.getVirtualMachineProxy();
        try {
            WatchpointRequest request;
            Field field = refType.fieldByName(this.getFieldName());
            if (field == null) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.missing.field.in.class", (Object[])new Object[]{this.getFieldName(), refType.name()}));
                return;
            }
            RequestManagerImpl manager = debugProcess.getRequestsManager();
            if (this.isWatchModification() && vm.canWatchFieldModification()) {
                request = manager.createModificationWatchpointRequest(this, field);
                debugProcess.getRequestsManager().enableRequest(request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Modification request added");
                }
            }
            if (this.isWatchAccess() && vm.canWatchFieldAccess()) {
                request = manager.createAccessWatchpointRequest(this, field);
                debugProcess.getRequestsManager().enableRequest(request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Access request added field = " + field.name() + "; refType = " + refType.name());
                }
            }
        }
        catch (ObjectCollectedException ex) {
            LOG.debug((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        String locationFileName;
        Location location = event.location();
        String locationQName = location.declaringType().name() + "." + location.method().name();
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = this.getSourcePosition().getFile().getName();
        }
        int locationLine = location.lineNumber();
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationEvent = (ModificationWatchpointEvent)event;
            ObjectReference object = modificationEvent.object();
            Field field = modificationEvent.field();
            if (object != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine});
        }
        if (event instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent accessEvent = (AccessWatchpointEvent)event;
            ObjectReference object = accessEvent.object();
            Field field = accessEvent.field();
            if (object != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine});
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className = this.getClassName();
        return className != null && !className.isEmpty() ? className + "." + this.getFieldName() : this.getFieldName();
    }

    public static FieldBreakpoint create(@NotNull Project project, String fieldName, XBreakpoint xBreakpoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/FieldBreakpoint", "create"));
        }
        FieldBreakpoint breakpoint = new FieldBreakpoint(project, fieldName, xBreakpoint);
        return (FieldBreakpoint)breakpoint.init();
    }

    @Override
    public boolean canMoveTo(SourcePosition position) {
        return super.canMoveTo(position) && PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, position) != null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getPsiField() != null;
    }

    @Override
    public boolean isAt(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/FieldBreakpoint", "isAt"));
        }
        PsiField field = FieldBreakpoint.findField(this.myProject, document, offset);
        return field == this.getPsiField();
    }

    public static PsiField findField(Project project, Document document, int offset) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
        int line = document.getLineNumber(offset);
        if (field == null) {
            final PsiField[] fld = new PsiField[]{null};
            XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

                public boolean process(PsiElement element) {
                    PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
                    if (field != null) {
                        fld[0] = field;
                        return false;
                    }
                    return true;
                }
            });
            field = fld[0];
        }
        return field;
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/FieldBreakpoint", "readExternal"));
        }
        super.readExternal(breakpointNode);
        this.setFieldName(breakpointNode.getAttributeValue("field_name"));
        if (this.getFieldName() == null) {
            throw new InvalidDataException("No field name for field breakpoint");
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_MODIFICATION"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ACCESS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    private boolean isWatchModification() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION;
    }

    private boolean isWatchAccess() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS;
    }

    private void setFieldName(String fieldName) {
        ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName = fieldName;
    }
}

