/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import org.jetbrains.annotations.NotNull;

public class EnableBreakpointRule {
    private final BreakpointManager myManager;
    private final boolean myLeaveEnabled;
    private final Breakpoint myMasterBreakpoint;
    private final Breakpoint mySlaveBreakpoint;

    public EnableBreakpointRule(@NotNull BreakpointManager manager, @NotNull Breakpoint masterBreakpoint, @NotNull Breakpoint slaveBreakpoint) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        if (masterBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        if (slaveBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        this(manager, masterBreakpoint, slaveBreakpoint, false);
    }

    public EnableBreakpointRule(@NotNull BreakpointManager manager, @NotNull Breakpoint masterBreakpoint, @NotNull Breakpoint slaveBreakpoint, boolean leaveEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        if (masterBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        if (slaveBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/debugger/ui/breakpoints/EnableBreakpointRule", "<init>"));
        }
        this.myMasterBreakpoint = masterBreakpoint;
        this.mySlaveBreakpoint = slaveBreakpoint;
        this.myManager = manager;
        this.myLeaveEnabled = leaveEnabled;
    }

    public Breakpoint getMasterBreakpoint() {
        return this.myMasterBreakpoint;
    }

    public Breakpoint getSlaveBreakpoint() {
        return this.mySlaveBreakpoint;
    }

    public boolean isLeaveEnabled() {
        return this.myLeaveEnabled;
    }

    public void init() {
        this.myManager.setBreakpointEnabled(this.getSlaveBreakpoint(), false);
    }

    public void dispose() {
        this.myManager.setBreakpointEnabled(this.getSlaveBreakpoint(), true);
    }

    public void processBreakpointHit(Breakpoint breakpointHit) {
        if (this.getMasterBreakpoint().equals(breakpointHit)) {
            this.myManager.setBreakpointEnabled(this.getSlaveBreakpoint(), true);
        } else if (this.getSlaveBreakpoint().equals(breakpointHit) && !this.myLeaveEnabled) {
            this.myManager.setBreakpointEnabled(this.getSlaveBreakpoint(), false);
        }
    }
}

