/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.intellij.xml.util.XmlStringUtil;
import com.sun.jdi.ReferenceType;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    @Nullable
    private RangeHighlighter myHighlighter;
    @Nullable
    private SourcePosition mySourcePosition;
    private boolean myVisible;
    private volatile Icon myIcon;
    @Nullable
    private String myClassName;
    @Nullable
    private String myPackageName;
    @Nullable
    private String myInvalidMessage;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected abstract Icon getInvalidIcon(boolean var1);

    protected abstract Icon getSetIcon(boolean var1);

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition pos = this.getSourcePosition();
        if (pos != null && pos.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.myPackageName;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        if (!this.isValid()) {
            RangeHighlighter highlighter = this.myHighlighter;
            if (highlighter != null) {
                highlighter.dispose();
            }
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
            this.updateGutter();
        }
        return this;
    }

    private void updateCaches(DebugProcessImpl debugProcess) {
        this.myIcon = this.calcIcon(debugProcess);
        this.myClassName = JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.getSourcePosition());
        this.myPackageName = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcess, this.getSourcePosition());
    }

    private Icon calcIcon(@Nullable DebugProcessImpl debugProcess) {
        boolean muted;
        boolean bl = muted = debugProcess != null && this.isMuted(debugProcess);
        if (!this.isEnabled()) {
            return this.getDisabledIcon(muted);
        }
        this.myInvalidMessage = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(muted);
        }
        if (debugProcess == null) {
            return this.getSetIcon(muted);
        }
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        boolean isVerified = this.myCachedVerifiedState || requestsManager.isVerified(this);
        String warning = requestsManager.getWarning(this);
        if (warning != null) {
            this.myInvalidMessage = warning;
            if (!isVerified) {
                return this.getInvalidIcon(muted);
            }
            return this.getVerifiedWarningsIcon(muted);
        }
        if (isVerified) {
            return this.getVerifiedIcon(muted);
        }
        return this.getSetIcon(muted);
    }

    protected BreakpointWithHighlighter(@NotNull Project project, XBreakpoint xBreakpoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "<init>"));
        }
        super(project, xBreakpoint);
        this.myVisible = true;
        this.myIcon = this.getSetIcon(false);
        this.reload();
    }

    public BreakpointWithHighlighter(@NotNull Project project, @NotNull RangeHighlighter highlighter, XBreakpoint breakpoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "<init>"));
        }
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "<init>"));
        }
        super(project, breakpoint);
        this.myVisible = true;
        this.myIcon = this.getSetIcon(false);
        this.myHighlighter = highlighter;
        this.setEditorFilter(highlighter);
        this.reload();
    }

    protected void setEditorFilter(RangeHighlighter highlighter) {
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myHighlighter;
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(final @Nullable XSourcePosition sourcePosition) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return sourcePosition != null && sourcePosition.getFile().isValid() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDescription() {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        buf.append("<html><body>");
        buf.append(this.getDisplayName());
        if (this.myInvalidMessage != null && !this.myInvalidMessage.isEmpty()) {
            buf.append("<br><font color='red'>");
            buf.append(DebuggerBundle.message((String)"breakpoint.warning", (Object[])new Object[]{this.myInvalidMessage}));
            buf.append("</font>");
        }
        buf.append("&nbsp;<br>&nbsp;");
        buf.append(DebuggerBundle.message((String)"breakpoint.property.name.suspend.policy", (Object[])new Object[0])).append(" : ");
        if ("SuspendNone".equals(this.getSuspendPolicy()) || !this.isSuspend()) {
            buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.none", (Object[])new Object[0]));
        } else if ("SuspendAll".equals(this.getSuspendPolicy())) {
            buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.all", (Object[])new Object[0]));
        } else if ("SuspendThread".equals(this.getSuspendPolicy())) {
            buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.thread", (Object[])new Object[0]));
        }
        buf.append("&nbsp;<br>&nbsp;");
        buf.append(DebuggerBundle.message((String)"breakpoint.property.name.log.message", (Object[])new Object[0])).append(": ");
        buf.append(this.isLogEnabled() ? CommonBundle.getYesButtonText() : CommonBundle.getNoButtonText());
        if (this.isLogExpressionEnabled()) {
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.log.expression", (Object[])new Object[0])).append(": ");
            buf.append(XmlStringUtil.escapeString((String)this.getLogMessage().getText()));
        }
        if (this.isConditionEnabled() && this.getCondition() != null && this.getCondition().getText() != null && !this.getCondition().getText().isEmpty()) {
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.condition", (Object[])new Object[0])).append(": ");
            buf.append(XmlStringUtil.escapeString((String)this.getCondition().getText()));
        }
        if (this.isCountFilterEnabled()) {
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
            buf.append(this.getCountFilter());
        }
        if (this.isClassFiltersEnabled()) {
            ClassFilter[] classFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
            for (ClassFilter classFilter : classFilters = this.getClassFilters()) {
                buf.append(classFilter.getPattern()).append(" ");
            }
        }
        if (this.isInstanceFiltersEnabled()) {
            InstanceFilter[] instanceFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
            for (InstanceFilter instanceFilter : instanceFilters = this.getInstanceFilters()) {
                buf.append(Long.toString(instanceFilter.getId())).append(" ");
            }
        }
        buf.append("</body></html>");
        String string = buf.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "getDescription"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public void reload() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        PsiFile psiFile = this.getPsiFile();
        if (position != null && psiFile != null) {
            this.mySourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)position.getLine());
            this.reload(psiFile);
        } else {
            this.mySourcePosition = null;
        }
    }

    @Nullable
    public PsiFile getPsiFile() {
        VirtualFile file;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        if (position != null && (file = position.getFile()).isValid()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(file);
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "createRequest"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isEnabled() || !debugProcess.isAttached() || this.isMuted(debugProcess) || !debugProcess.getRequestsManager().findRequests(this).isEmpty()) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        this.createOrWaitPrepare(debugProcess, this.getSourcePosition());
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "isMuted"));
        }
        return debugProcess.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType classType) {
        if (!this.isEnabled() || !this.isValid()) {
            return;
        }
        this.createRequestForPreparedClass((DebugProcessImpl)debugProcess, classType);
        this.updateUI();
    }

    @Override
    public final void updateUI() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Project project = this.getProject();
        DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

            @Override
            public void run() {
                if (!BreakpointWithHighlighter.this.isValid()) {
                    return;
                }
                DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
                final DebugProcessImpl debugProcess = context.getDebugProcess();
                if (debugProcess == null || !debugProcess.isAttached()) {
                    BreakpointWithHighlighter.this.updateCaches(null);
                    BreakpointWithHighlighter.this.updateGutter();
                } else {
                    debugProcess.getManagerThread().invoke(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointWithHighlighter.this.updateCaches(debugProcess);
                                }
                            });
                            DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointWithHighlighter.this.updateGutter();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private void updateGutter() {
        if (this.myVisible && this.isValid()) {
            XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
            breakpointManager.updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.getIcon(), null);
        }
    }

    @Override
    public void delete() {
        RangeHighlighter highlighter;
        if (this.isVisible() && (highlighter = this.getHighlighter()) != null) {
            DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

                @Override
                public void run() {
                    highlighter.dispose();
                    BreakpointWithHighlighter.super.delete();
                }
            });
        }
    }

    public boolean isAt(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "isAt"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        int line = document.getLineNumber(offset);
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        return position != null && position.getLine() == line && position.getFile().equals(file);
    }

    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(final SourcePosition sourcePosition) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JVMNameUtil.getClassAt(sourcePosition);
            }
        });
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    public boolean canMoveTo(@Nullable SourcePosition position) {
        if (position == null || !position.getFile().isValid()) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document == null) {
            return false;
        }
        int spOffset = position.getOffset();
        if (spOffset < 0) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        return breakpointManager.findBreakpoint(document, spOffset, this.getCategory()) == null;
    }

    public boolean moveTo(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "moveTo"));
        }
        if (!this.canMoveTo(position)) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        PsiFile oldFile = this.getSourcePosition().getFile();
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        Document oldDocument = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(oldFile);
        if (document == null || oldDocument == null) {
            return false;
        }
        RangeHighlighter newHighlighter = BreakpointWithHighlighter.createHighlighter(this.myProject, document, position.getLine());
        if (newHighlighter == null) {
            return false;
        }
        RangeHighlighter oldHighlighter = this.myHighlighter;
        this.myHighlighter = newHighlighter;
        this.reload();
        if (!this.isValid()) {
            this.myHighlighter.dispose();
            this.myHighlighter = oldHighlighter;
            this.reload();
            return false;
        }
        if (oldHighlighter != null) {
            oldHighlighter.dispose();
        }
        DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().fireBreakpointChanged(this);
        this.updateUI();
        return true;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    @Nullable
    public Document getDocument() {
        RangeHighlighter highlighter = this.getHighlighter();
        if (highlighter != null) {
            return highlighter.getDocument();
        }
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            PsiFile file = position.getFile();
            return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
        }
        return null;
    }

    public int getLineIndex() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    @Nullable
    protected static RangeHighlighter createHighlighter(@NotNull Project project, @NotNull Document document, int lineIndex) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "createHighlighter"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "createHighlighter"));
        }
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return null;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        RangeHighlighterEx highlighter = ((MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true)).addPersistentLineHighlighter(lineIndex, 2001, attributes);
        if (highlighter == null || !highlighter.isValid()) {
            return null;
        }
        highlighter.putUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY, Boolean.TRUE);
        highlighter.setErrorStripeTooltip(DebuggerBundle.message((String)"breakpoint.tooltip.text", (Object[])new Object[]{lineIndex + 1}));
        return highlighter;
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        String packageName;
        if (breakpointNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "readExternal"));
        }
        super.readExternal(breakpointNode);
        String className = breakpointNode.getAttributeValue("class");
        if (className != null) {
            this.myClassName = className;
        }
        if ((packageName = breakpointNode.getAttributeValue("package")) != null) {
            this.myPackageName = packageName;
        }
    }
}

