/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.ui.XBreakpointPackageGroup;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointGroupingByPackageRule<B>
extends XBreakpointGroupingRule<B, XBreakpointPackageGroup> {
    protected XBreakpointGroupingByPackageRule() {
        super("XBreakpointGroupingByPackageRule", "Group by package");
    }

    public int getPriority() {
        return 800;
    }

    public XBreakpointPackageGroup getGroup(@NotNull B breakpoint, @NotNull Collection<XBreakpointPackageGroup> groups) {
        Breakpoint javaBreakpoint;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/XBreakpointGroupingByPackageRule", "getGroup"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/XBreakpointGroupingByPackageRule", "getGroup"));
        }
        String packageName = null;
        if (breakpoint instanceof XBreakpoint && (javaBreakpoint = BreakpointManager.findBreakpoint((XBreakpoint)breakpoint)) != null) {
            packageName = javaBreakpoint.getPackageName();
        }
        if (packageName == null) {
            return null;
        }
        for (XBreakpointPackageGroup group : groups) {
            if (!StringUtil.equals((CharSequence)group.getPackageName(), (CharSequence)packageName)) continue;
            return group;
        }
        return new XBreakpointPackageGroup(packageName);
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Package;
    }
}

