/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.ui.XBreakpointClassGroup;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XBreakpointGroupingByClassRule<B>
extends XBreakpointGroupingRule<B, XBreakpointClassGroup> {
    XBreakpointGroupingByClassRule() {
        super("XBreakpointGroupingByClassRule", "Group by Class");
    }

    public boolean isAlwaysEnabled() {
        return false;
    }

    public int getPriority() {
        return 400;
    }

    public XBreakpointClassGroup getGroup(@NotNull B b, @NotNull Collection<XBreakpointClassGroup> groups) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/XBreakpointGroupingByClassRule", "getGroup"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/XBreakpointGroupingByClassRule", "getGroup"));
        }
        if (b instanceof XBreakpoint) {
            Breakpoint javaBreakpoint = BreakpointManager.findBreakpoint((XBreakpoint)b);
            if (javaBreakpoint == null) {
                return null;
            }
            String className = javaBreakpoint.getShortClassName();
            String packageName = javaBreakpoint.getPackageName();
            if (className == null) {
                return null;
            }
            for (XBreakpointClassGroup group : groups) {
                if (!group.getClassName().equals(className) || !group.getPackageName().equals(packageName)) continue;
                return group;
            }
            return new XBreakpointClassGroup(packageName, className);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Class;
    }
}

