/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExportDialog
extends DialogWrapper {
    private final JTextArea myTextArea = new JTextArea();
    private TextFieldWithBrowseButton myTfFilePath;
    private final Project myProject;
    private final DebugProcessImpl myDebugProcess;
    private final CopyToClipboardAction myCopyToClipboardAction = new CopyToClipboardAction();
    @NonNls
    private static final String DEFAULT_REPORT_FILE_NAME = "threads_report.txt";

    public ExportDialog(DebugProcessImpl debugProcess, String destinationDirectory) {
        super(debugProcess.getProject(), true);
        this.myDebugProcess = debugProcess;
        this.myProject = debugProcess.getProject();
        this.setTitle(DebuggerBundle.message((String)"threads.export.dialog.title", (Object[])new Object[0]));
        this.setOKButtonText(DebuggerBundle.message((String)"button.save", (Object[])new Object[0]));
        this.init();
        this.setOKActionEnabled(false);
        this.myCopyToClipboardAction.setEnabled(false);
        this.myTextArea.setText(MessageDescriptor.EVALUATING.getLabel());
        debugProcess.getManagerThread().invoke(new ExportThreadsCommand(ApplicationManager.getApplication().getModalityStateForComponent((Component)this.myTextArea)));
        this.myTfFilePath.setText(destinationDirectory + File.separator + DEFAULT_REPORT_FILE_NAME);
        this.setHorizontalStretch(1.5f);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.myCopyToClipboardAction, this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/ExportDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.run.export.thread");
    }

    protected JComponent createNorthPanel() {
        JPanel box = new JPanel(new BorderLayout());
        box.add((Component)new JLabel(DebuggerBundle.message((String)"label.threads.export.dialog.file", (Object[])new Object[0])), "West");
        this.myTfFilePath = new TextFieldWithBrowseButton();
        this.myTfFilePath.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        box.add((Component)this.myTfFilePath, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        panel.add(Box.createVerticalStrut(7), "South");
        return panel;
    }

    protected JComponent createCenterPanel() {
        this.myTextArea.setEditable(false);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTextArea);
        pane.setPreferredSize(new Dimension(400, 300));
        return pane;
    }

    protected void doOKAction() {
        String path = this.myTfFilePath.getText();
        File file = new File(path);
        if (file.isDirectory()) {
            Messages.showMessageDialog((Project)this.myProject, (String)DebuggerBundle.message((String)"error.threads.export.dialog.file.is.directory", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"threads.export.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        } else if (file.exists()) {
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)DebuggerBundle.message((String)"error.threads.export.dialog.file.already.exists", (Object[])new Object[]{path}), (String)DebuggerBundle.message((String)"threads.export.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                super.doOKAction();
            }
        } else {
            super.doOKAction();
        }
    }

    public String getFilePath() {
        return this.myTfFilePath.getText();
    }

    public String getTextToSave() {
        return this.myTextArea.getText();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.ExportDialog";
    }

    public static String getExportThreadsText(VirtualMachineProxyImpl vmProxy) {
        StringBuffer buffer = new StringBuffer(512);
        List<ThreadReference> threads = vmProxy.getVirtualMachine().allThreads();
        for (ThreadReference threadReference : threads) {
            ThreadGroupReference groupReference;
            String name = ExportDialog.threadName(threadReference);
            if (name == null) continue;
            buffer.append(name);
            ReferenceType referenceType = threadReference.referenceType();
            if (referenceType != null) {
                Value value;
                Field priority;
                Value value2;
                Field daemon = referenceType.fieldByName("daemon");
                if (daemon != null && (value2 = threadReference.getValue(daemon)) instanceof BooleanValue && ((BooleanValue)value2).booleanValue()) {
                    buffer.append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                }
                if ((priority = referenceType.fieldByName("priority")) != null && (value = threadReference.getValue(priority)) instanceof IntegerValue) {
                    buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)value).intValue()}));
                }
            }
            if ((groupReference = threadReference.threadGroup()) != null) {
                buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.group", (Object[])new Object[]{groupReference.name()}));
            }
            buffer.append(", ").append(DebuggerBundle.message((String)"threads.export.attribute.label.status", (Object[])new Object[]{DebuggerUtilsEx.getThreadStatusText(threadReference.status())}));
            try {
                String waitedThreadName;
                ThreadReference waitedThread;
                ObjectReference waitedMonitor;
                if (vmProxy.canGetOwnedMonitorInfo() && vmProxy.canGetMonitorInfo()) {
                    List<ObjectReference> list = threadReference.ownedMonitors();
                    for (ObjectReference reference : list) {
                        List<ThreadReference> waiting = reference.waitingThreads();
                        for (ThreadReference thread : waiting) {
                            String waitingThreadName = ExportDialog.threadName(thread);
                            if (waitingThreadName == null) continue;
                            buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{waitingThreadName}));
                        }
                    }
                }
                ObjectReference objectReference = waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? threadReference.currentContendedMonitor() : null;
                if (waitedMonitor != null && vmProxy.canGetMonitorInfo() && (waitedThread = waitedMonitor.owningThread()) != null && (waitedThreadName = ExportDialog.threadName(waitedThread)) != null) {
                    buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{waitedThreadName, ThreadDumpAction.renderObject(waitedMonitor)}));
                }
                List<StackFrame> frames = threadReference.frames();
                for (StackFrame stackFrame : frames) {
                    Location location = stackFrame.location();
                    buffer.append("\n\t  ").append(ExportDialog.renderLocation(location));
                }
            }
            catch (IncompatibleThreadStateException e) {
                buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    private static String renderLocation(Location location) {
        String sourceName;
        try {
            sourceName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            sourceName = "Unknown Source";
        }
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{location.declaringType().name() + "." + location.method().name(), sourceName, location.lineNumber()});
    }

    private static String threadName(ThreadReference threadReference) {
        try {
            return threadReference.name() + "@" + threadReference.uniqueID();
        }
        catch (ObjectCollectedException e) {
            return null;
        }
    }

    private class ExportThreadsCommand
    extends DebuggerCommandImpl {
        protected ModalityState myModalityState;

        public ExportThreadsCommand(ModalityState modalityState) {
            this.myModalityState = modalityState;
        }

        private void setText(final String text) {
            DebuggerInvocationUtil.invokeLater(ExportDialog.this.myProject, new Runnable(){

                @Override
                public void run() {
                    ExportDialog.this.myTextArea.setText(text);
                    ExportDialog.this.setOKActionEnabled(true);
                    ExportDialog.this.myCopyToClipboardAction.setEnabled(true);
                }
            }, this.myModalityState);
        }

        @Override
        protected void action() {
            this.setText(ExportDialog.getExportThreadsText(ExportDialog.this.myDebugProcess.getVirtualMachineProxy()));
        }
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        public CopyToClipboardAction() {
            super(DebuggerBundle.message((String)"button.copy", (Object[])new Object[0]));
            this.putValue("ShortDescription", DebuggerBundle.message((String)"export.dialog.copy.action.description", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = StringUtil.convertLineSeparators((String)ExportDialog.this.myTextArea.getText());
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
        }
    }
}

