/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final int myFrameFromBottomIndex;
    private int myFrameIndex;
    private StackFrame myStackFrame;
    private ObjectReference myThisReference;
    private ClassLoaderReference myClassLoader;
    private Boolean myIsObsolete;
    private Map<LocalVariable, Value> myAllValues;

    public StackFrameProxyImpl(ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/jdi/StackFrameProxyImpl", "<init>"));
        }
        super(threadProxy.getVirtualMachine());
        this.myFrameIndex = -1;
        this.myIsObsolete = null;
        this.myThreadProxy = threadProxy;
        this.myFrameFromBottomIndex = fromBottomIndex;
        this.myStackFrame = frame;
    }

    public boolean isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myIsObsolete != null) {
            return this.myIsObsolete;
        }
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                boolean isObsolete = this.getVirtualMachine().canRedefineClasses() && this.location().method().isObsolete();
                this.myIsObsolete = isObsolete ? Boolean.TRUE : Boolean.FALSE;
                return isObsolete;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) {
                    this.myIsObsolete = Boolean.TRUE;
                    return true;
                }
                throw e;
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
        return false;
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("caches cleared " + super.toString());
        }
        this.myFrameIndex = -1;
        this.myStackFrame = null;
        this.myIsObsolete = null;
        this.myThisReference = null;
        this.myClassLoader = null;
        this.myAllValues = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myStackFrame == null) {
            try {
                ThreadReference threadRef = this.myThreadProxy.getThreadReference();
                this.myStackFrame = threadRef.frame(this.getFrameIndex());
            }
            catch (IndexOutOfBoundsException e) {
                throw new EvaluateException(e.getMessage(), (Throwable)e);
            }
            catch (ObjectCollectedException ignored) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myStackFrame;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameIndex == -1) {
            int count = this.myThreadProxy.frameCount();
            if (this.myFrameFromBottomIndex > count) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.myFrameIndex = count - this.myFrameFromBottomIndex;
        }
        return this.myFrameIndex;
    }

    public VirtualMachineProxyImpl getVirtualMachine() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    @Nullable
    public Location location() throws EvaluateException {
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
        return null;
    }

    public ThreadReferenceProxyImpl threadProxy() {
        return this.myThreadProxy;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException e) {
            return "StackFrameProxyImpl: " + e.getMessage() + "; frameFromBottom = " + this.myFrameFromBottomIndex + " threadName = " + this.threadProxy().name();
        }
    }

    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        block6: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.checkValid();
            try {
                for (int attempt = 0; attempt < 2; ++attempt) {
                    try {
                        if (this.myThisReference == null) {
                            this.myThisReference = this.getStackFrame().thisObject();
                        }
                        break;
                    }
                    catch (InvalidStackFrameException ignored) {
                        this.clearCaches();
                        continue;
                    }
                }
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) break block6;
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myThisReference;
    }

    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                List<LocalVariable> list = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> locals = new ArrayList<LocalVariableProxyImpl>(list.size());
                for (LocalVariable localVariable : list) {
                    LOG.assertTrue(localVariable != null);
                    locals.add(new LocalVariableProxyImpl(this, localVariable));
                }
                return locals;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
        return Collections.emptyList();
    }

    public LocalVariableProxyImpl visibleVariableByName(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? new LocalVariableProxyImpl(this, variable) : null;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String name) throws EvaluateException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/jdi/StackFrameProxyImpl", "visibleValueByName"));
        }
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? this.getValue(new LocalVariableProxyImpl(this, variable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                try {
                    return this.getStackFrame().visibleVariableByName(name);
                }
                catch (InvalidStackFrameException e) {
                    try {
                        error = e;
                        this.clearCaches();
                        continue;
                    }
                    catch (InvalidStackFrameException e2) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)e2);
                    }
                }
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), error);
        }
        return null;
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getAllValues().get(localVariable.getVariable());
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
        return null;
    }

    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                return stackFrame != null ? stackFrame.getArgumentValues() : Collections.emptyList();
            }
            catch (InternalException e) {
                if (e.errorCode() == 32) {
                    return Collections.emptyList();
                }
                throw e;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
        return Collections.emptyList();
    }

    private Map<LocalVariable, Value> getAllValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myAllValues == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.myAllValues = new THashMap(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (InconsistentDebugInfoException ignored) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myAllValues;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        InvalidStackFrameException error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                LocalVariable variable = localVariable.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(variable, value instanceof ObjectReference ? (ObjectReference)value : value);
                if (this.myAllValues != null) {
                    this.myAllValues.put(variable, stackFrame.getValue(variable));
                }
                return;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        if (error != null) {
            throw new EvaluateException(error.getMessage(), (Throwable)error);
        }
    }

    public int hashCode() {
        return 31 * this.myThreadProxy.hashCode() + this.myFrameFromBottomIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)obj;
        if (frameProxy == this) {
            return true;
        }
        return this.myFrameFromBottomIndex == frameProxy.myFrameFromBottomIndex && this.myThreadProxy.equals(frameProxy.myThreadProxy);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws EvaluateException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.location().declaringType().classLoader();
        }
        return this.myClassLoader;
    }

    public boolean isBottom() {
        return this.myFrameFromBottomIndex == 1;
    }

    public int getIndexFromBottom() {
        return this.myFrameFromBottomIndex;
    }
}

