/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WatchItemData
extends DescriptorData<WatchItemDescriptor> {
    private final TextWithImports myText;
    private final Value myValue;

    public WatchItemData(TextWithImports text, @Nullable Value value) {
        this.myText = text;
        this.myValue = value;
    }

    @Override
    protected WatchItemDescriptor createDescriptorImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/descriptors/data/WatchItemData", "createDescriptorImpl"));
        }
        return new WatchItemDescriptor(project, this.myText, this.myValue);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof WatchItemData) {
            return this.myText.equals(((WatchItemData)object).myText);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.myText.hashCode();
    }

    @Override
    public DisplayKey<WatchItemDescriptor> getDisplayKey() {
        return new SimpleDisplayKey<WatchItemDescriptor>(this.myText.getText());
    }
}

