/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;

    public TextWithImportsImpl(PsiExpression expression) {
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression.getText();
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text, @NotNull String imports, @Nullable FileType fileType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/engine/evaluation/TextWithImportsImpl", "<init>"));
        }
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/debugger/engine/evaluation/TextWithImportsImpl", "<init>"));
        }
        this.myKind = kind;
        this.myText = text;
        this.myImports = imports;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/engine/evaluation/TextWithImportsImpl", "<init>"));
        }
        this.myKind = kind;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        String string = this.myImports;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/TextWithImportsImpl", "getImports"));
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result = result + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result = result + '\r' + this.myFileType.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }
}

