/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CodeFragmentFactoryContextWrapper
extends CodeFragmentFactory {
    public static final Key<Value> LABEL_VARIABLE_VALUE_KEY = Key.create((String)"_label_variable_value_key_");
    public static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    private final CodeFragmentFactory myDelegate;

    public CodeFragmentFactoryContextWrapper(CodeFragmentFactory delegate) {
        this.myDelegate = delegate;
    }

    public JavaCodeFragment createCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return this.myDelegate.createCodeFragment(item, this.wrapContext(project, context), project);
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return this.myDelegate.createPresentationCodeFragment(item, this.wrapContext(project, context), project);
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return this.myDelegate.isContextAccepted(contextElement);
    }

    public LanguageFileType getFileType() {
        return this.myDelegate.getFileType();
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return this.myDelegate.getEvaluatorBuilder();
    }

    private PsiElement wrapContext(Project project, PsiElement originalContext) {
        Map<ObjectReference, ValueMarkup> markupMap;
        if (project.isDefault()) {
            return originalContext;
        }
        PsiElement context = originalContext;
        DebugProcessImpl process = DebuggerManagerEx.getInstanceEx(project).getContext().getDebugProcess();
        if (process != null && (markupMap = ValueDescriptorImpl.getMarkupMap(process)) != null && markupMap.size() > 0) {
            final Pair<String, Map<String, ObjectReference>> markupVariables = CodeFragmentFactoryContextWrapper.createMarkupVariablesText(markupMap);
            int offset = ((String)markupVariables.getFirst()).length() - 1;
            TextWithImportsImpl textWithImports = new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, (String)markupVariables.getFirst(), "", (FileType)this.myDelegate.getFileType());
            JavaCodeFragment codeFragment = this.myDelegate.createCodeFragment((TextWithImports)textWithImports, context, project);
            codeFragment.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitLocalVariable(PsiLocalVariable variable) {
                    String name = variable.getName();
                    variable.putUserData(LABEL_VARIABLE_VALUE_KEY, ((Map)markupVariables.getSecond()).get(name));
                }
            });
            PsiElement newContext = codeFragment.findElementAt(offset);
            if (newContext != null) {
                context = newContext;
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String, Map<String, ObjectReference>> createMarkupVariablesText(Map<ObjectReference, ValueMarkup> markupMap) {
        HashMap<String, ObjectReference> reverseMap = new HashMap<String, ObjectReference>();
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            Iterator<Map.Entry<ObjectReference, ValueMarkup>> it = markupMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ObjectReference, ValueMarkup> entry = it.next();
                ObjectReference objectRef = entry.getKey();
                ValueMarkup markup = entry.getValue();
                String labelName = markup.getText();
                if (!StringUtil.isJavaIdentifier((String)labelName)) continue;
                try {
                    String typeName = objectRef.type().name();
                    labelName = labelName + DEBUG_LABEL_SUFFIX;
                    if (buffer.length() > 0) {
                        buffer.append("\n");
                    }
                    buffer.append(typeName).append(" ").append(labelName).append(";");
                    reverseMap.put(labelName, objectRef);
                }
                catch (ObjectCollectedException e) {
                    it.remove();
                }
            }
            buffer.append(" ");
            Pair pair = new Pair((Object)buffer.toString(), reverseMap);
            return pair;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }
}

