/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.BaseValueAction;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.TextViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ViewTextAction
extends BaseValueAction {
    @Override
    protected void processText(Project project, String text, DebuggerTreeNodeImpl node, DebuggerContextImpl debuggerContext) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        String labelText = descriptor instanceof ValueDescriptorImpl ? ((ValueDescriptorImpl)descriptor).getValueLabel() : null;
        MyDialog dialog = new MyDialog(project);
        dialog.setTitle(labelText != null ? "View Text for: " + labelText : "View Text");
        dialog.setText(text);
        dialog.show();
    }

    private static class MyDialog
    extends DialogWrapper {
        private final EditorTextField myTextViewer;

        private MyDialog(Project project) {
            super(project, false);
            this.setModal(false);
            this.setCancelButtonText("Close");
            this.setCrossClosesWindow(true);
            this.myTextViewer = new TextViewer(project, true, true);
            this.init();
        }

        public void setText(String text) {
            this.myTextViewer.setText(text);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ViewTextAction$MyDialog", "createActions"));
            }
            return actionArray;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.debugger.actions.ViewTextAction";
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)((Object)this.myTextViewer), "Center");
            panel.setPreferredSize(new Dimension(300, 200));
            return panel;
        }
    }
}

