/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.Nullable;

public class ToggleFieldBreakpointAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Document document;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        SourcePosition place = ToggleFieldBreakpointAction.getPlace(e);
        if (place != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(place.getFile())) != null) {
            FieldBreakpoint breakpoint;
            DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
            BreakpointManager manager = debuggerManager.getBreakpointManager();
            int offset = place.getOffset();
            FieldBreakpoint fieldBreakpoint = breakpoint = offset >= 0 ? manager.findBreakpoint(document, offset, FieldBreakpoint.CATEGORY) : null;
            if (breakpoint == null) {
                FieldBreakpoint fieldBreakpoint2 = manager.addFieldBreakpoint(document, offset);
                if (fieldBreakpoint2 != null) {
                    ObjectReference object;
                    DebuggerTreeNodeImpl selectedNode;
                    if (DebuggerAction.isContextView(e) && (selectedNode = DebuggerAction.getSelectedNode(e.getDataContext())) != null && selectedNode.getDescriptor() instanceof FieldDescriptorImpl && (object = ((FieldDescriptorImpl)selectedNode.getDescriptor()).getObject()) != null) {
                        long id = object.uniqueID();
                        InstanceFilter[] instanceFilters = new InstanceFilter[]{InstanceFilter.create(Long.toString(id))};
                        fieldBreakpoint2.setInstanceFilters(instanceFilters);
                        fieldBreakpoint2.setInstanceFiltersEnabled(true);
                    }
                    RequestManagerImpl.createRequests(fieldBreakpoint2);
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null) {
                        manager.editBreakpoint(fieldBreakpoint2, editor);
                    }
                }
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    public void update(AnActionEvent event) {
        SourcePosition place = ToggleFieldBreakpointAction.getPlace(event);
        boolean toEnable = place != null;
        Presentation presentation = event.getPresentation();
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace())) {
            presentation.setVisible(toEnable);
        } else if (DebuggerAction.isContextView(event)) {
            Document document;
            presentation.setText(DebuggerBundle.message((String)"action.add.field.watchpoint.text", (Object[])new Object[0]));
            Project project = (Project)event.getData(CommonDataKeys.PROJECT);
            if (project != null && place != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(place.getFile())) != null) {
                FieldBreakpoint fieldBreakpoint;
                int offset = place.getOffset();
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
                FieldBreakpoint fieldBreakpoint2 = fieldBreakpoint = offset >= 0 ? breakpointManager.findBreakpoint(document, offset, FieldBreakpoint.CATEGORY) : null;
                if (fieldBreakpoint != null) {
                    presentation.setEnabled(false);
                    return;
                }
            }
        }
        presentation.setVisible(toEnable);
    }

    @Nullable
    public static SourcePosition getPlace(AnActionEvent event) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl debugProcess;
        DataContext dataContext = event.getDataContext();
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace())) {
            PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiField) {
                return SourcePosition.createFromElement((PsiElement)psiElement);
            }
            return null;
        }
        final DebuggerTreeNodeImpl selectedNode = DebuggerAction.getSelectedNode(dataContext);
        if (selectedNode != null && selectedNode.getDescriptor() instanceof FieldDescriptorImpl && (debugProcess = (debuggerContext = DebuggerAction.getDebuggerContext(dataContext)).getDebugProcess()) != null) {
            final Ref positionRef = new Ref(null);
            debugProcess.getManagerThread().invokeAndWait(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            FieldDescriptorImpl descriptor = (FieldDescriptorImpl)selectedNode.getDescriptor();
                            positionRef.set((Object)descriptor.getSourcePosition(project, debuggerContext));
                        }
                    });
                }
            });
            SourcePosition sourcePosition = (SourcePosition)positionRef.get();
            if (sourcePosition != null) {
                return sourcePosition;
            }
        }
        if (DebuggerAction.isContextView(event)) {
            DebuggerTreeNodeImpl node;
            DebuggerTree tree = (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
            if (tree != null && tree.getSelectionPath() != null && (node = (DebuggerTreeNodeImpl)tree.getSelectionPath().getLastPathComponent()) != null && node.getDescriptor() instanceof FieldDescriptorImpl) {
                PsiField psiField;
                Field field = ((FieldDescriptorImpl)node.getDescriptor()).getField();
                DebuggerSession session = tree.getDebuggerContext().getDebuggerSession();
                PsiClass psiClass = DebuggerUtils.findClass((String)field.declaringType().name(), (Project)project, (GlobalSearchScope)(session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project)));
                if (psiClass != null && (psiField = (psiClass = (PsiClass)psiClass.getNavigationElement()).findFieldByName(field.name(), true)) != null) {
                    return SourcePosition.createFromElement((PsiElement)psiField);
                }
            }
            return null;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        if (editor != null) {
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file != null) {
                PsiField field;
                FileType fileType;
                VirtualFile virtualFile = file.getVirtualFile();
                FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                if ((StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) && (field = FieldBreakpoint.findField(project, document, editor.getCaretModel().getOffset())) != null) {
                    return SourcePosition.createFromElement((PsiElement)field);
                }
            }
        }
        return null;
    }
}

