/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeInplaceEditor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.IJSwingUtilities;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SetValueAction
extends DebuggerAction {
    public void update(AnActionEvent e) {
        NodeDescriptorImpl descriptor;
        boolean enable = false;
        DebuggerTreeNodeImpl node = SetValueAction.getSelectedNode(e.getDataContext());
        if (node != null && (descriptor = node.getDescriptor()) instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            enable = valueDescriptor.canSetValue();
        }
        e.getPresentation().setVisible(enable);
    }

    private void update(final DebuggerContextImpl context) {
        DebuggerInvocationUtil.swingInvokeLater(context.getProject(), new Runnable(){

            @Override
            public void run() {
                DebuggerSession session = context.getDebuggerSession();
                if (session != null) {
                    session.refresh(false);
                }
            }
        });
    }

    public void actionPerformed(AnActionEvent event) {
        EvaluationDescriptor evaluationDescriptor;
        DebuggerTreeNodeImpl node = SetValueAction.getSelectedNode(event.getDataContext());
        if (node == null) {
            return;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return;
        }
        if (!((ValueDescriptorImpl)descriptor).canSetValue()) {
            return;
        }
        DebuggerTree tree = SetValueAction.getTree(event.getDataContext());
        final DebuggerContextImpl debuggerContext = SetValueAction.getDebuggerContext(event.getDataContext());
        tree.saveState(node);
        if (descriptor instanceof FieldDescriptorImpl) {
            FieldDescriptorImpl fieldDescriptor = (FieldDescriptorImpl)descriptor;
            final Field field = fieldDescriptor.getField();
            if (!field.isStatic()) {
                final ObjectReference object = fieldDescriptor.getObject();
                if (object != null) {
                    this.askAndSet(node, debuggerContext, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            object.setValue(field, SetValueAction.this.preprocessValue(evaluationContext, newValue, field.type()));
                            SetValueAction.this.update(debuggerContext);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, field.declaringType().classLoader());
                        }
                    });
                }
            } else {
                ReferenceType refType = field.declaringType();
                if (refType instanceof ClassType) {
                    final ClassType classType = (ClassType)refType;
                    this.askAndSet(node, debuggerContext, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            classType.setValue(field, SetValueAction.this.preprocessValue(evaluationContext, newValue, field.type()));
                            SetValueAction.this.update(debuggerContext);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, field.declaringType().classLoader());
                        }
                    });
                }
            }
        } else if (descriptor instanceof LocalVariableDescriptorImpl) {
            LocalVariableDescriptorImpl localDescriptor = (LocalVariableDescriptorImpl)descriptor;
            final LocalVariableProxyImpl local = localDescriptor.getLocalVariable();
            if (local != null) {
                this.askAndSet(node, debuggerContext, new SetValueRunnable(){

                    @Override
                    public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                        debuggerContext.getFrameProxy().setValue(local, SetValueAction.this.preprocessValue(evaluationContext, newValue, local.getType()));
                        SetValueAction.this.update(debuggerContext);
                    }

                    @Override
                    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                        return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, evaluationContext.getClassLoader());
                    }
                });
            }
        } else if (descriptor instanceof ArrayElementDescriptorImpl) {
            final ArrayElementDescriptorImpl elementDescriptor = (ArrayElementDescriptorImpl)descriptor;
            final ArrayReference array = elementDescriptor.getArray();
            if (array != null) {
                if (VirtualMachineProxyImpl.isCollected(array)) {
                    Messages.showWarningDialog((Component)((Object)tree), (String)(DebuggerBundle.message((String)"evaluation.error.array.collected", (Object[])new Object[0]) + "\n" + DebuggerBundle.message((String)"warning.recalculate", (Object[])new Object[0])), (String)DebuggerBundle.message((String)"title.set.value", (Object[])new Object[0]));
                    node.getParent().calcValue();
                    return;
                }
                final ArrayType arrType = (ArrayType)array.referenceType();
                this.askAndSet(node, debuggerContext, new SetValueRunnable(){

                    @Override
                    public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                        array.setValue(elementDescriptor.getIndex(), SetValueAction.this.preprocessValue(evaluationContext, newValue, arrType.componentType()));
                        SetValueAction.this.update(debuggerContext);
                    }

                    @Override
                    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                        return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, arrType.classLoader());
                    }
                });
            }
        } else if (descriptor instanceof EvaluationDescriptor && (evaluationDescriptor = (EvaluationDescriptor)descriptor).canSetValue()) {
            this.askAndSet(node, debuggerContext, new SetValueRunnable(){

                @Override
                public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                    Modifier modifier = evaluationDescriptor.getModifier();
                    modifier.setValue(SetValueAction.this.preprocessValue(evaluationContext, newValue, modifier.getExpectedType()));
                    SetValueAction.this.update(debuggerContext);
                }

                @Override
                public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                    return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, evaluationContext.getClassLoader());
                }
            });
        }
    }

    private Value preprocessValue(EvaluationContextImpl context, Value value, Type varType) throws EvaluateException {
        String v;
        if (value != null && "java.lang.String".equals(varType.name()) && !(value instanceof StringReference) && (v = DebuggerUtilsEx.getValueAsString((EvaluationContext)context, (Value)value)) != null) {
            value = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf(v);
        }
        if (value instanceof DoubleValue) {
            double dValue = ((DoubleValue)value).doubleValue();
            if (varType instanceof FloatType && (double)1.4E-45f <= dValue && dValue <= 3.4028234663852886E38) {
                value = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf((float)dValue);
            }
        }
        if (value != null) {
            if (varType instanceof PrimitiveType) {
                if (!(value instanceof PrimitiveValue)) {
                    value = (Value)new UnBoxingEvaluator(new IdentityEvaluator(value)).evaluate(context);
                }
            } else if (UnBoxingEvaluator.isTypeUnboxable(varType.name()) && value instanceof PrimitiveValue) {
                value = (Value)new BoxingEvaluator(new IdentityEvaluator(value)).evaluate(context);
            }
        }
        return value;
    }

    private static void setValue(String expressionToShow, ExpressionEvaluator evaluator, EvaluationContextImpl evaluationContext, SetValueRunnable setValueRunnable) throws EvaluateException {
        try {
            Value value = evaluator.evaluate((EvaluationContext)evaluationContext);
            setValueRunnable.setValue(evaluationContext, value);
        }
        catch (IllegalArgumentException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)ex.getMessage());
        }
        catch (InvalidTypeException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (ClassNotLoadedException ex) {
            if (!evaluationContext.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)ex);
            }
            try {
                ReferenceType refType = setValueRunnable.loadClass(evaluationContext, ex.className());
                if (refType != null) {
                    SetValueAction.setValue(expressionToShow, evaluator, evaluationContext, setValueRunnable);
                }
            }
            catch (InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ClassNotLoadedException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InvalidTypeException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    private void askAndSet(final DebuggerTreeNodeImpl node, final DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, debuggerContext.getProject());
        DebuggerContextCommandImpl askSetAction = new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction() {
                NodeDescriptorImpl descriptor = node.getDescriptor();
                String initialString = "";
                if (descriptor instanceof ValueDescriptorImpl) {
                    Value currentValue = ((ValueDescriptorImpl)descriptor).getValue();
                    if (currentValue instanceof StringReference) {
                        initialString = DebuggerUtilsEx.getValueOrErrorAsString(debuggerContext.createEvaluationContext(), currentValue);
                        initialString = initialString == null ? "" : "\"" + DebuggerUtilsEx.translateStringValue((String)initialString) + "\"";
                    } else if (currentValue instanceof PrimitiveValue) {
                        NodeRenderer renderer = ((ValueDescriptorImpl)descriptor).getRenderer(debuggerContext.getDebugProcess());
                        initialString = SetValueAction.getDisplayableString((PrimitiveValue)currentValue, renderer instanceof NodeRenderer && "HexRenderer".equals(renderer.getUniqueId()));
                    }
                    final String initialString1 = initialString;
                    Project project = debuggerContext.getProject();
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            SetValueAction.this.showEditor(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, initialString1), node, debuggerContext, setValueRunnable);
                        }
                    });
                }
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        debuggerContext.getDebugProcess().getManagerThread().startProgress(askSetAction, progressWindow);
    }

    private void showEditor(TextWithImports initialString, final DebuggerTreeNodeImpl node, final DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        final JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BoxLayout(editorPanel, 0));
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setIcon(node.getIcon());
        DebuggerTreeRenderer.getDescriptorTitle(debuggerContext, node.getDescriptor()).appendToComponent((ColoredTextContainer)label);
        editorPanel.add((Component)label);
        final DebuggerExpressionComboBox comboBox = new DebuggerExpressionComboBox(debuggerContext.getProject(), PositionUtil.getContextElement((StackFrameContext)debuggerContext), "setValue", DefaultCodeFragmentFactory.getInstance());
        comboBox.setText(initialString);
        comboBox.selectAll();
        editorPanel.add(comboBox);
        final DebuggerTreeInplaceEditor editor = new DebuggerTreeInplaceEditor(node){

            @Override
            public JComponent createInplaceEditorComponent() {
                return editorPanel;
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return comboBox;
            }

            @Override
            public Editor getEditor() {
                return comboBox.getEditor();
            }

            @Override
            public JComponent getEditorComponent() {
                return comboBox.getEditorComponent();
            }

            private void flushValue() {
                Editor editor;
                if (comboBox.isPopupVisible()) {
                    comboBox.selectPopupValue();
                }
                if ((editor = this.getEditor()) == null) {
                    return;
                }
                final TextWithImports text = comboBox.getText();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)debuggerContext.getProject()).getPsiFile(editor.getDocument());
                final ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, this.getProject());
                EditorEvaluationCommand evaluationCommand = new EditorEvaluationCommand(this.getEditor(), (PsiElement)psiFile, debuggerContext, progressWindow){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    @Override
                    public void threadAction() {
                        try {
                            this.evaluate();
                        }
                        catch (EvaluateException e) {
                            progressWindow.cancel();
                            if (!progressWindow.isCanceled()) {
                                DebuggerInvocationUtil.swingInvokeLater(debuggerContext.getProject(), new Runnable(){

                                    @Override
                                    public void run() {
                                        comboBox.addRecent(text);
                                        this.cancelEditing();
                                    }
                                });
                            }
                        }
                        catch (ProcessCanceledException e2) {
                            progressWindow.cancel();
                            {
                                catch (Throwable throwable) {
                                    if (!progressWindow.isCanceled()) {
                                        DebuggerInvocationUtil.swingInvokeLater(debuggerContext.getProject(), new /* invalid duplicate definition of identical inner class */);
                                    }
                                    throw throwable;
                                }
                            }
                            if (!progressWindow.isCanceled()) {
                                DebuggerInvocationUtil.swingInvokeLater(debuggerContext.getProject(), new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        if (!progressWindow.isCanceled()) {
                            DebuggerInvocationUtil.swingInvokeLater(debuggerContext.getProject(), new /* invalid duplicate definition of identical inner class */);
                        }
                    }

                    protected Object evaluate(final EvaluationContextImpl evaluationContext) throws EvaluateException {
                        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(evaluationContext.getProject(), new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                return EvaluatorBuilderImpl.build(text, ContextUtil.getContextElement((StackFrameContext)evaluationContext), ContextUtil.getSourcePosition((StackFrameContext)evaluationContext));
                            }
                        });
                        SetValueAction.setValue(text.getText(), evaluator, evaluationContext, new SetValueRunnable(){

                            @Override
                            public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                                if (!progressWindow.isCanceled()) {
                                    setValueRunnable.setValue(evaluationContext, newValue);
                                    node.calcValue();
                                }
                            }

                            @Override
                            public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, EvaluateException, IncompatibleThreadStateException, InvalidTypeException {
                                return setValueRunnable.loadClass(evaluationContext, className);
                            }
                        });
                        return null;
                    }
                };
                progressWindow.addListener(new ProgressIndicatorListenerAdapter(){

                    @Override
                    public void stopped() {
                        if (!progressWindow.isCanceled()) {
                            IJSwingUtilities.invoke(new Runnable(){

                                @Override
                                public void run() {
                                    this.cancelEditing();
                                }
                            });
                        }
                    }
                });
                progressWindow.setTitle(DebuggerBundle.message((String)"progress.set.value", (Object[])new Object[0]));
                debuggerContext.getDebugProcess().getManagerThread().startProgress(evaluationCommand, progressWindow);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelEditing() {
                try {
                    super.cancelEditing();
                }
                finally {
                    comboBox.dispose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doOKAction() {
                try {
                    this.flushValue();
                }
                finally {
                    comboBox.dispose();
                }
            }
        };
        final DebuggerStateManager stateManager = DebuggerManagerEx.getInstanceEx(debuggerContext.getProject()).getContextManager();
        stateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                if (event != 12) {
                    stateManager.removeListener(this);
                    editor.cancelEditing();
                }
            }
        });
        node.getTree().hideTooltip();
        editor.show();
    }

    private static String getDisplayableString(PrimitiveValue value, boolean showAsHex) {
        if (value instanceof CharValue) {
            long longValue = value.longValue();
            return showAsHex ? "0x" + Long.toHexString(longValue).toUpperCase() : Long.toString(longValue);
        }
        if (value instanceof ByteValue) {
            byte val = value.byteValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 2) {
                strValue = strValue.substring(strValue.length() - 2);
            }
            return showAsHex ? "0x" + strValue : value.toString();
        }
        if (value instanceof ShortValue) {
            short val = value.shortValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 4) {
                strValue = strValue.substring(strValue.length() - 4);
            }
            return showAsHex ? "0x" + strValue : value.toString();
        }
        if (value instanceof IntegerValue) {
            int val = value.intValue();
            return showAsHex ? "0x" + Integer.toHexString(val).toUpperCase() : value.toString();
        }
        if (value instanceof LongValue) {
            long val = value.longValue();
            return showAsHex ? "0x" + Long.toHexString(val).toUpperCase() + "L" : value.toString() + "L";
        }
        return DebuggerUtilsEx.translateStringValue((String)value.toString());
    }

    private static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        public ReferenceType loadClass(EvaluationContextImpl var1, String var2) throws EvaluateException, InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;
    }
}

