/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class PauseActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/PauseActionHandler", "perform"));
        }
        DebuggerSession session = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        if (session != null) {
            session.pause();
        }
    }

    @Override
    public boolean isHidden(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/PauseActionHandler", "isHidden"));
        }
        return DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession() == null;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/PauseActionHandler", "isEnabled"));
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        return debuggerSession != null && !debuggerSession.getProcess().isPausePressed() && (debuggerSession.isEvaluating() || debuggerSession.isRunning() || PauseActionHandler.isSingleThreadSuspended(debuggerSession));
    }

    private static boolean isSingleThreadSuspended(DebuggerSession debuggerSession) {
        SuspendContextImpl suspendContext = debuggerSession.getContextManager().getContext().getSuspendContext();
        return suspendContext != null && !suspendContext.isResumed() && suspendContext.getSuspendPolicy() == 1;
    }
}

