/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.util.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaSmartStepTarget
extends SmartStepTarget {
    private final PsiLambdaExpression myLambda;
    private final int myOrdinal;

    public LambdaSmartStepTarget(@NotNull PsiLambdaExpression lambda, @Nullable String label, @Nullable PsiElement highlightElement, int ordinal, Range<Integer> lines) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/LambdaSmartStepTarget", "<init>"));
        }
        super(label, highlightElement, true, lines);
        this.myLambda = lambda;
        this.myOrdinal = ordinal;
    }

    public PsiLambdaExpression getLambda() {
        return this.myLambda;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaSmartStepTarget that = (LambdaSmartStepTarget)o;
        if (this.myOrdinal != that.myOrdinal) {
            return false;
        }
        return this.myLambda.equals(that.myLambda);
    }

    public int hashCode() {
        int result = this.myLambda.hashCode();
        result = 31 * result + this.myOrdinal;
        return result;
    }
}

