/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.EvaluationDialog;
import com.intellij.debugger.ui.ExpressionEvaluationDialog;
import com.intellij.debugger.ui.StatementEvaluationDialog;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class EvaluateActionHandler
extends DebuggerActionHandler {
    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/EvaluateActionHandler", "isEnabled"));
        }
        DebuggerContextImpl context = DebuggerAction.getDebuggerContext(event.getDataContext());
        if (context != null) {
            DebuggerSession debuggerSession = context.getDebuggerSession();
            return debuggerSession != null && debuggerSession.isPaused();
        }
        return false;
    }

    @Override
    public void perform(final @NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/EvaluateActionHandler", "perform"));
        }
        DataContext dataContext = event.getDataContext();
        final DebuggerContextImpl context = DebuggerAction.getDebuggerContext(dataContext);
        if (context == null) {
            return;
        }
        Editor editor = (Editor)event.getData(DataKeys.EDITOR);
        TextWithImports editorText = DebuggerUtilsEx.getEditorText(editor);
        if (editorText == null) {
            final DebuggerTreeNodeImpl selectedNode = DebuggerAction.getSelectedNode(dataContext);
            final String actionName = event.getPresentation().getText();
            if (selectedNode != null && selectedNode.getDescriptor() instanceof ValueDescriptorImpl) {
                context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

                    @Override
                    public void threadAction() {
                        try {
                            final TextWithImports evaluationText = DebuggerTreeNodeExpression.createEvaluationText(selectedNode, context);
                            DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                                @Override
                                public void run() {
                                    EvaluateActionHandler.showEvaluationDialog(project, evaluationText);
                                }
                            });
                        }
                        catch (EvaluateException e1) {
                            DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)actionName);
                                }
                            });
                        }
                    }

                    @Override
                    protected void commandCancelled() {
                        DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                            @Override
                            public void run() {
                                if (selectedNode.getDescriptor() instanceof WatchItemDescriptor) {
                                    try {
                                        TextWithImports editorText = DebuggerTreeNodeExpression.createEvaluationText(selectedNode, context);
                                        EvaluateActionHandler.showEvaluationDialog(project, editorText);
                                    }
                                    catch (EvaluateException e1) {
                                        Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)actionName);
                                    }
                                }
                            }
                        });
                    }
                });
                return;
            }
        }
        EvaluateActionHandler.showEvaluationDialog(project, editorText);
    }

    public static void showEvaluationDialog(Project project, TextWithImports defaultExpression, String dialogType) {
        if (defaultExpression == null) {
            defaultExpression = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
        }
        CodeFragmentKind kind = "EvaluateFragment".equals(dialogType) ? CodeFragmentKind.CODE_BLOCK : CodeFragmentKind.EXPRESSION;
        DebuggerSettings.getInstance().EVALUATION_DIALOG_TYPE = dialogType;
        TextWithImportsImpl text = new TextWithImportsImpl(kind, defaultExpression.getText(), defaultExpression.getImports(), defaultExpression.getFileType());
        EvaluationDialog dialog = "EvaluateFragment".equals(dialogType) ? new StatementEvaluationDialog(project, text) : new ExpressionEvaluationDialog(project, text);
        dialog.show();
    }

    public static void showEvaluationDialog(Project project, TextWithImports text) {
        EvaluateActionHandler.showEvaluationDialog(project, text, DebuggerSettings.getInstance().EVALUATION_DIALOG_TYPE);
    }
}

