/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerAction
extends AnAction {
    private static final DebuggerTreeNodeImpl[] EMPTY_TREE_NODE_ARRAY = new DebuggerTreeNodeImpl[0];

    @Nullable
    public static DebuggerTree getTree(DataContext dataContext) {
        return (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
    }

    @Nullable
    public static DebuggerTreePanel getPanel(DataContext dataContext) {
        return (DebuggerTreePanel)DebuggerTreePanel.DATA_KEY.getData(dataContext);
    }

    @Nullable
    public static DebuggerTreeNodeImpl getSelectedNode(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        if (tree.getSelectionCount() != 1) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object component = path.getLastPathComponent();
        if (!(component instanceof DebuggerTreeNodeImpl)) {
            return null;
        }
        return (DebuggerTreeNodeImpl)component;
    }

    @Nullable
    public static DebuggerTreeNodeImpl[] getSelectedNodes(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return EMPTY_TREE_NODE_ARRAY;
        }
        ArrayList<DebuggerTreeNodeImpl> nodes = new ArrayList<DebuggerTreeNodeImpl>(paths.length);
        for (TreePath path : paths) {
            Object component = path.getLastPathComponent();
            if (!(component instanceof DebuggerTreeNodeImpl)) continue;
            nodes.add((DebuggerTreeNodeImpl)component);
        }
        return nodes.toArray(new DebuggerTreeNodeImpl[nodes.size()]);
    }

    public static DebuggerContextImpl getDebuggerContext(DataContext dataContext) {
        DebuggerTreePanel panel = DebuggerAction.getPanel(dataContext);
        if (panel != null) {
            return panel.getContext();
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null ? DebuggerManagerEx.getInstanceEx(project).getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
    }

    @Nullable
    public static DebuggerStateManager getContextManager(DataContext dataContext) {
        DebuggerTreePanel panel = DebuggerAction.getPanel(dataContext);
        return panel == null ? null : panel.getContextManager();
    }

    public static boolean isContextView(AnActionEvent e) {
        return "Debugger.EvaluationDialogPopup".equals(e.getPlace()) || "Debugger.FramePanelPopup".equals(e.getPlace()) || "Debugger.WatchesPanelPopup".equals(e.getPlace()) || "Debugger.InspectPanelPopup".equals(e.getPlace());
    }

    public static Disposable installEditAction(final JTree tree, String actionName) {
        final DoubleClickListener listener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)tree);
                GotoFrameSourceAction.doAction(dataContext);
                return true;
            }
        };
        listener.installOn((Component)tree);
        final AnAction action = ActionManager.getInstance().getAction(actionName);
        action.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)tree);
        return new Disposable(){

            public void dispose() {
                listener.uninstall((Component)tree);
                action.unregisterCustomShortcutSet((JComponent)tree);
            }
        };
    }

    public static boolean isFirstStart(AnActionEvent event) {
        String key = "initalized";
        if (event.getPresentation().getClientProperty(key) != null) {
            return false;
        }
        event.getPresentation().putClientProperty(key, (Object)key);
        return true;
    }

    public static void enableAction(final AnActionEvent event, final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                event.getPresentation().setEnabled(enable);
                event.getPresentation().setVisible(true);
            }
        });
    }
}

