/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public abstract class BaseValueAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext actionContext = e.getDataContext();
        final DebuggerTreeNodeImpl node = BaseValueAction.getSelectedNode(actionContext);
        final Value value = BaseValueAction.getValue(node);
        if (value == null) {
            return;
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(actionContext);
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        if (debuggerManager == null) {
            return;
        }
        final DebuggerContextImpl debuggerContext = debuggerManager.getContext();
        if (debuggerContext == null || debuggerContext.getDebuggerSession() == null) {
            return;
        }
        final ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, project);
        SuspendContextCommandImpl getTextCommand = new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction() throws Exception {
                progressWindow.setText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{"toString()"}));
                final String valueAsString = DebuggerUtilsEx.getValueOrErrorAsString(debuggerContext.createEvaluationContext(), value);
                if (progressWindow.isCanceled()) {
                    return;
                }
                DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                    @Override
                    public void run() {
                        String text = valueAsString;
                        if (text == null) {
                            text = "";
                        }
                        BaseValueAction.this.processText(project, text, node, debuggerContext);
                    }
                });
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        debuggerContext.getDebugProcess().getManagerThread().startProgress(getTextCommand, progressWindow);
    }

    protected abstract void processText(Project var1, String var2, DebuggerTreeNodeImpl var3, DebuggerContextImpl var4);

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Value value = BaseValueAction.getValue(BaseValueAction.getSelectedNode(e.getDataContext()));
        presentation.setEnabled(value != null);
        presentation.setVisible(value != null);
    }

    @Nullable
    private static Value getValue(DebuggerTreeNodeImpl node) {
        if (node == null) {
            return null;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptor)) {
            return null;
        }
        return ((ValueDescriptor)((Object)descriptor)).getValue();
    }
}

