/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugUIEnvironment
implements DebugUIEnvironment {
    private final Project myProject;
    private final Executor myExecutor;
    private final ProgramRunner myRunner;
    private final ExecutionEnvironment myExecutionEnvironment;
    @Nullable
    private RunContentDescriptor myReuseContent;
    private final RunProfile myRunProfile;
    private final DebugEnvironment myModelEnvironment;

    public DefaultDebugUIEnvironment(Project project, Executor executor, ProgramRunner runner, ExecutionEnvironment environment, RunProfileState state, @Nullable RunContentDescriptor reuseContent, RemoteConnection remoteConnection, boolean pollConnection) {
        this.myProject = project;
        this.myExecutor = executor;
        this.myRunner = runner;
        this.myExecutionEnvironment = environment;
        this.myRunProfile = environment.getRunProfile();
        this.myModelEnvironment = new DefaultDebugEnvironment(project, executor, runner, this.myRunProfile, state, remoteConnection, pollConnection);
        this.myReuseContent = reuseContent;
        if (this.myReuseContent != null) {
            Disposer.register((Disposable)this.myReuseContent, (Disposable)new Disposable(){

                public void dispose() {
                    DefaultDebugUIEnvironment.this.myReuseContent = null;
                }
            });
        }
    }

    @Override
    public DebugEnvironment getEnvironment() {
        return this.myModelEnvironment;
    }

    @Override
    @Nullable
    public RunContentDescriptor getReuseContent() {
        return this.myReuseContent;
    }

    @Override
    public Icon getIcon() {
        return this.myRunProfile.getIcon();
    }

    @Override
    public void initLogs(RunContentDescriptor content, LogFilesManager logFilesManager) {
        ProcessHandler processHandler = content.getProcessHandler();
        if (this.myRunProfile instanceof RunConfigurationBase) {
            RunConfigurationBase runConfiguration = (RunConfigurationBase)this.myRunProfile;
            logFilesManager.registerFileMatcher(runConfiguration);
            logFilesManager.initLogConsoles(runConfiguration, processHandler);
            OutputFileUtil.attachDumpListener(runConfiguration, processHandler, content.getExecutionConsole());
        }
    }

    @Override
    public void initActions(RunContentDescriptor content, DefaultActionGroup actionGroup) {
        RestartAction restartAction = new RestartAction(this.myExecutor, this.myRunner, content, this.myExecutionEnvironment);
        actionGroup.add((AnAction)restartAction, Constraints.FIRST);
        restartAction.registerShortcut(content.getComponent());
        actionGroup.add((AnAction)new CloseAction(this.myExecutor, content, this.myProject));
        actionGroup.add((AnAction)new ContextHelpAction(this.myExecutor.getHelpId()));
    }

    @Override
    public RunProfile getRunProfile() {
        return this.myRunProfile;
    }
}

