/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerInvocationUtil {
    public static void swingInvokeLater(final @Nullable Project project, final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/DebuggerInvocationUtil", "swingInvokeLater"));
        }
        if (project == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    runnable.run();
                }
            }
        });
    }

    public static void invokeLater(@Nullable Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/DebuggerInvocationUtil", "invokeLater"));
        }
        if (project != null) {
            ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
        }
    }

    public static void invokeLater(@Nullable Project project, @NotNull Runnable runnable, ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/DebuggerInvocationUtil", "invokeLater"));
        }
        if (project != null) {
            ApplicationManager.getApplication().invokeLater(runnable, state, project.getDisposed());
        }
    }

    public static void invokeAndWait(final Project project, final @NotNull Runnable runnable, ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/DebuggerInvocationUtil", "invokeAndWait"));
        }
        if (project != null) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        runnable.run();
                    }
                }
            }, state);
        }
    }

    public static <T> T commitAndRunReadAction(Project project, final EvaluatingComputable<T> computable) throws EvaluateException {
        final Throwable[] ex = new Throwable[]{null};
        Object result = PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(new Computable<T>(){

            public T compute() {
                try {
                    return computable.compute();
                }
                catch (RuntimeException e) {
                    ex[0] = e;
                }
                catch (Exception th) {
                    ex[0] = th;
                }
                return null;
            }
        });
        if (ex[0] != null) {
            if (ex[0] instanceof RuntimeException) {
                throw (RuntimeException)ex[0];
            }
            throw (EvaluateException)ex[0];
        }
        return (T)result;
    }
}

