/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockReferenceProvidersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    private final CoreEncodingRegistry myEncodingRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final VirtualFileSystem myJarFileSystem;
    private final Disposable myParentDisposable;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
        Extensions.cleanRootArea((Disposable)this.myParentDisposable);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myEncodingRegistry = new CoreEncodingRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication((Application)this.myApplication, (Getter)new StaticGetter((Object)this.myFileTypeRegistry), (Getter)new StaticGetter((Object)this.myEncodingRegistry), (Disposable)this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        CoreApplicationEnvironment.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        VirtualFileSystem[] fs = new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem};
        VirtualFileManagerImpl virtualFileManager = new VirtualFileManagerImpl(fs, (MessageBus)new MessageBusImpl((Object)this.myApplication, null));
        CoreApplicationEnvironment.registerComponentInstance(appContainer, VirtualFileManager.class, virtualFileManager);
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.myApplication.registerService(DefaultASTFactory.class, new CoreASTFactory());
        this.myApplication.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.myApplication.registerService(ReferenceProvidersRegistry.class, new MockReferenceProvidersRegistry());
        this.myApplication.registerService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.myApplication.registerService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.myApplication.registerService(MetaDataRegistrar.class, new MetaRegistry());
        CoreApplicationEnvironment.registerApplicationExtensionPoint(ContentBasedFileSubstitutor.EP_NAME, ContentBasedFileSubstitutor.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint(MetaDataContributor.EP_NAME, MetaDataContributor.class);
        ProgressIndicatorProvider.ourInstance = this.createProgressIndicatorProvider();
        this.myApplication.registerService(JobLauncher.class, this.createJobLauncher());
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationService"));
        }
        if (serviceImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationService"));
        }
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        CoreVirtualFilePointerManager coreVirtualFilePointerManager = new CoreVirtualFilePointerManager();
        if (coreVirtualFilePointerManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createVirtualFilePointerManager"));
        }
        return coreVirtualFilePointerManager;
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment", "createApplication"));
        }
        MockApplicationEx mockApplicationEx = new MockApplicationEx(parentDisposable);
        if (mockApplicationEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createApplication"));
        }
        return mockApplicationEx;
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        JobLauncher jobLauncher = new JobLauncher(){

            @Override
            public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<T> thingProcessor) throws ProcessCanceledException {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                for (T thing : things) {
                    if (thingProcessor.process(thing)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<T> thingProcessor) {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                return this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor);
            }

            @Override
            @NotNull
            public <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<? extends T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<T> thingProcessor) {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                AsyncFutureResult asyncFutureResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
                try {
                    boolean result = this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor);
                    asyncFutureResult.set((Object)result);
                }
                catch (Throwable t) {
                    asyncFutureResult.setException(t);
                }
                AsyncFutureResult asyncFutureResult2 = asyncFutureResult;
                if (asyncFutureResult2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                return asyncFutureResult2;
            }

            @Override
            @NotNull
            public Job<Void> submitToJobThread(int priority, @NotNull Runnable action, Consumer<Future> onDoneCallback) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreApplicationEnvironment$2", "submitToJobThread"));
                }
                action.run();
                if (onDoneCallback != null) {
                    onDoneCallback.consume((Object)new Future(){

                        @Override
                        public boolean cancel(boolean mayInterruptIfRunning) {
                            return false;
                        }

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }

                        @Override
                        public boolean isDone() {
                            return true;
                        }

                        public Object get() throws InterruptedException, ExecutionException {
                            return null;
                        }

                        public Object get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                            if (timeUnit == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreApplicationEnvironment$2$1", "get"));
                            }
                            return null;
                        }
                    });
                }
                Job job = Job.NULL_JOB;
                if (job == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment$2", "submitToJobThread"));
                }
                return job;
            }
        };
        if (jobLauncher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createJobLauncher"));
        }
        return jobLauncher;
    }

    @NotNull
    protected ProgressIndicatorProvider createProgressIndicatorProvider() {
        ProgressIndicatorProvider progressIndicatorProvider = new ProgressIndicatorProvider(){

            public ProgressIndicator getProgressIndicator() {
                return new EmptyProgressIndicator();
            }

            protected void doCheckCanceled() throws ProcessCanceledException {
            }

            public NonCancelableSection startNonCancelableSection() {
                return NonCancelableSection.EMPTY;
            }
        };
        if (progressIndicatorProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createProgressIndicatorProvider"));
        }
        return progressIndicatorProvider;
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        CoreJarFileSystem coreJarFileSystem = new CoreJarFileSystem();
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createJarFileSystem"));
        }
        return coreJarFileSystem;
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = new CoreLocalFileSystem();
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createLocalFileSystem"));
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.myApplication;
        if (mockApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "getApplication"));
        }
        return mockApplication;
    }

    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    public <T> void registerApplicationComponent(Class<T> interfaceClass, T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
    }

    public void registerFileType(FileType fileType, String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(ParserDefinition definition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
    }

    public static <T> void registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension((Object)language, object);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.removeExplicitExtension((Object)language, object);
            }
        });
    }

    public void registerParserDefinition(Language language, ParserDefinition parserDefinition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, language, (Object)parserDefinition);
    }

    public <T> void addExplicitExtension(final @NotNull FileTypeExtension<T> instance, final @NotNull FileType fileType, final @NotNull T object) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        instance.addExplicitExtension((Object)fileType, object);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.removeExplicitExtension((Object)fileType, object);
            }
        });
    }

    public <T> void addExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    public static <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(area, name, aClass);
    }

    public static <T> void registerExtensionPoint(ExtensionsArea area, String name, Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), name, aClass);
    }

    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    public VirtualFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }
}

