/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        if (type instanceof IFileElementType) {
            FileElement fileElement = new FileElement((IElementType)type, text);
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createLazy"));
            }
            return fileElement;
        }
        LazyParseableElement lazyParseableElement = new LazyParseableElement((IElementType)type, text);
        if (lazyParseableElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createLazy"));
        }
        return lazyParseableElement;
    }

    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type) {
        if (type instanceof IFileElementType) {
            FileElement fileElement = new FileElement(type, null);
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createComposite"));
            }
            return fileElement;
        }
        CompositeElement compositeElement = new CompositeElement(type);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createComposite"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public LeafElement createLeaf(IElementType type, CharSequence text) {
        Language lang = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type)) {
            LeafElement leafElement = this.createComment(type, text);
            if (leafElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createLeaf"));
            }
            return leafElement;
        }
        LeafPsiElement leafPsiElement = new LeafPsiElement(type, text);
        if (leafPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreASTFactory", "createLeaf"));
        }
        return leafPsiElement;
    }

    @Override
    public LeafElement createComment(IElementType type, CharSequence text) {
        return new PsiCoreCommentImpl(type, text);
    }
}

