/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.DefaultMessageHandler");
    private final Project myProject;
    private final SequentialTaskExecutor myTaskExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);

    protected DefaultMessageHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void buildStarted(UUID sessionId) {
    }

    @Override
    public final void handleBuildMessage(final Channel channel, final UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        switch (msg.getType()) {
            case BUILD_EVENT: {
                this.handleBuildEvent(sessionId, msg.getBuildEvent());
                break;
            }
            case COMPILE_MESSAGE: {
                this.handleCompileMessage(sessionId, msg.getCompileMessage());
                break;
            }
            case CONSTANT_SEARCH_TASK: {
                final CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task = msg.getConstantSearchTask();
                this.myTaskExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMessageHandler.this.handleConstantSearchTask(channel, sessionId, task);
                    }
                });
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);

    private void handleConstantSearchTask(final Channel channel, final UUID sessionId, final CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        AtomicBoolean canceled;
        do {
            canceled = new AtomicBoolean(false);
            DumbService.getInstance((Project)this.myProject).waitForSmartMode();
            ProgressIndicatorUtils.runWithWriteActionPriority(new ReadTask(){

                @Override
                public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/server/DefaultMessageHandler$2", "computeInReadAction"));
                    }
                    if (DumbService.isDumb((Project)DefaultMessageHandler.this.myProject)) {
                        canceled.set(true);
                        return;
                    }
                    DefaultMessageHandler.this.doHandleConstantSearchTask(channel, sessionId, task);
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/server/DefaultMessageHandler$2", "onCanceled"));
                    }
                    canceled.set(true);
                }
            });
        } while (canceled.get());
    }

    private void doHandleConstantSearchTask(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        block14: {
            String ownerClassName = task.getOwnerClassName();
            final String fieldName = task.getFieldName();
            final int accessFlags = task.getAccessFlags();
            boolean accessChanged = task.getIsAccessChanged();
            boolean isRemoved = task.getIsFieldRemoved();
            boolean canceled = false;
            final Ref isSuccess = Ref.create((Object)Boolean.TRUE);
            final Set<String> affectedPaths = Collections.synchronizedSet(new HashSet());
            try {
                if (this.isDumbMode()) {
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: cannot search in dumb mode");
                    break block14;
                }
                final String qualifiedName = ownerClassName.replace('$', '.');
                final PsiClass[] classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                    public PsiClass[] compute() {
                        return JavaPsiFacade.getInstance((Project)DefaultMessageHandler.this.myProject).findClasses(qualifiedName, GlobalSearchScope.allScope((Project)DefaultMessageHandler.this.myProject));
                    }
                });
                try {
                    if (isRemoved) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (classes.length > 0) {
                                    for (PsiClass aClass : classes) {
                                        boolean success;
                                        boolean bl = success = aClass.isValid() && DefaultMessageHandler.this.performRemovedConstantSearch(aClass, fieldName, accessFlags, affectedPaths);
                                        if (success) continue;
                                        isSuccess.set((Object)Boolean.FALSE);
                                        break;
                                    }
                                } else {
                                    isSuccess.set((Object)DefaultMessageHandler.this.performRemovedConstantSearch(null, fieldName, accessFlags, affectedPaths));
                                }
                            }
                        });
                        break block14;
                    }
                    if (classes.length > 0) {
                        Collection changedFields = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiField>>(){

                            public Collection<PsiField> compute() {
                                SmartList fields = new SmartList();
                                for (PsiClass aClass : classes) {
                                    if (!aClass.isValid()) {
                                        return Collections.emptyList();
                                    }
                                    PsiField changedField = aClass.findFieldByName(fieldName, false);
                                    if (changedField == null) continue;
                                    fields.add(changedField);
                                }
                                return fields;
                            }
                        });
                        if (changedFields.isEmpty()) {
                            isSuccess.set((Object)Boolean.FALSE);
                            LOG.debug("Constant search task: field " + fieldName + " not found in classes " + qualifiedName);
                        } else {
                            for (PsiField changedField : changedFields) {
                                if (!accessChanged && ClsUtil.isPrivate((int)accessFlags)) continue;
                                this.affectDirectUsages(changedField, accessFlags, accessChanged, affectedPaths);
                            }
                        }
                        break block14;
                    }
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: class " + qualifiedName + " not found");
                }
                catch (Throwable e) {
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: failed with message " + e.getMessage());
                }
            }
            catch (ProcessCanceledException e) {
                canceled = true;
                throw e;
            }
            finally {
                if (!canceled) {
                    DefaultMessageHandler.notifyConstantSearchFinished(channel, sessionId, ownerClassName, fieldName, (Ref<Boolean>)isSuccess, affectedPaths);
                }
            }
        }
    }

    private static void notifyConstantSearchFinished(Channel channel, UUID sessionId, String ownerClassName, String fieldName, Ref<Boolean> isSuccess, Set<String> affectedPaths) {
        CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.newBuilder();
        builder.setOwnerClassName(ownerClassName);
        builder.setFieldName(fieldName);
        if (((Boolean)isSuccess.get()).booleanValue()) {
            builder.setIsSuccess(true);
            builder.addAllPath(affectedPaths);
            LOG.debug("Constant search task: " + affectedPaths.size() + " affected files found");
        } else {
            builder.setIsSuccess(false);
            LOG.debug("Constant search task: unsuccessful");
        }
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.CONSTANT_SEARCH_RESULT).setConstantSearchResult(builder.build()).build()));
    }

    private boolean isDumbMode() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        boolean isDumb = dumbService.isDumb();
        if (isDumb) {
            for (int idx = 0; idx < 5; ++idx) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                isDumb = dumbService.isDumb();
                if (!isDumb) break;
            }
        }
        return isDumb;
    }

    private boolean performRemovedConstantSearch(@Nullable PsiClass aClass, String fieldName, int fieldAccessFlags, final Set<String> affectedPaths) {
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        final Ref result = new Ref((Object)Boolean.TRUE);
        final PsiFile fieldContainingFile = aClass != null ? aClass.getContainingFile() : null;
        DefaultMessageHandler.processIdentifiers(psiSearchHelper, new PsiElementProcessor<PsiIdentifier>(){

            public boolean execute(@NotNull PsiIdentifier identifier) {
                if (identifier == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/server/DefaultMessageHandler$6", "execute"));
                }
                try {
                    VirtualFile vFile;
                    PsiFile usageFile;
                    PsiClass ownerClass;
                    PsiElement parent = identifier.getParent();
                    if (parent instanceof PsiReferenceExpression && (ownerClass = DefaultMessageHandler.getOwnerClass(parent)) != null && ownerClass.getQualifiedName() != null && (usageFile = ownerClass.getContainingFile()) != null && !usageFile.equals(fieldContainingFile) && (vFile = usageFile.getOriginalFile().getVirtualFile()) != null) {
                        affectedPaths.add(vFile.getPath());
                    }
                    return true;
                }
                catch (PsiInvalidElementAccessException ignored) {
                    result.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: PIEAE thrown while searching of usages of removed constant");
                    return false;
                }
            }
        }, fieldName, this.getSearchScope(aClass, fieldAccessFlags), (short)1);
        return (Boolean)result.get();
    }

    private SearchScope getSearchScope(PsiClass aClass, int fieldAccessFlags) {
        PsiFile containingFile;
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (aClass != null && ClsUtil.isPackageLocal((int)fieldAccessFlags) && (containingFile = aClass.getContainingFile()) instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage != null) {
                searchScope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
                searchScope = searchScope.intersectWith(aClass.getUseScope());
            }
        }
        return searchScope;
    }

    private static boolean processIdentifiers(PsiSearchHelper helper, final @NotNull PsiElementProcessor<PsiIdentifier> processor, @NotNull String identifier, @NotNull SearchScope searchScope, short searchContext) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/server/DefaultMessageHandler", "processIdentifiers"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/server/DefaultMessageHandler", "processIdentifiers"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/compiler/server/DefaultMessageHandler", "processIdentifiers"));
        }
        TextOccurenceProcessor processor1 = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                return !(element instanceof PsiIdentifier) || processor.execute((PsiElement)((PsiIdentifier)element));
            }
        };
        return helper.processElementsWithWord(processor1, searchScope, identifier, searchContext, true, false);
    }

    private void affectDirectUsages(final PsiField psiField, final int fieldAccessFlags, final boolean ignoreAccessScope, final Set<String> affectedPaths) throws ProcessCanceledException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (psiField.isValid()) {
                    PsiFile fieldContainingFile = psiField.getContainingFile();
                    HashSet<PsiFile> processedFiles = new HashSet<PsiFile>();
                    if (fieldContainingFile != null) {
                        processedFiles.add(fieldContainingFile);
                    }
                    Collection references = DefaultMessageHandler.this.doFindReferences(psiField, fieldAccessFlags, ignoreAccessScope);
                    for (PsiReferenceExpression ref : references) {
                        VirtualFile vFile;
                        PsiElement usage = ref.getElement();
                        PsiFile containingPsi = usage.getContainingFile();
                        if (containingPsi == null || !processedFiles.add(containingPsi) || (vFile = containingPsi.getOriginalFile().getVirtualFile()) == null) continue;
                        affectedPaths.add(vFile.getPath());
                    }
                }
            }
        });
    }

    private Collection<PsiReferenceExpression> doFindReferences(final PsiField psiField, int fieldAccessFlags, boolean ignoreAccessScope) {
        final SmartList result = new SmartList();
        GlobalSearchScope searchScope = ignoreAccessScope ? GlobalSearchScope.projectScope((Project)this.myProject) : this.getSearchScope(psiField.getContainingClass(), fieldAccessFlags);
        DefaultMessageHandler.processIdentifiers(PsiSearchHelper.SERVICE.getInstance((Project)this.myProject), new PsiElementProcessor<PsiIdentifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(@NotNull PsiIdentifier identifier) {
                PsiReferenceExpression refExpression;
                if (identifier == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/server/DefaultMessageHandler$9", "execute"));
                }
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiReferenceExpression && (refExpression = (PsiReferenceExpression)parent).isReferenceTo((PsiElement)psiField)) {
                    SmartList smartList = result;
                    synchronized (smartList) {
                        result.add((Object)refExpression);
                    }
                }
                return true;
            }
        }, psiField.getName(), (SearchScope)searchScope, (short)1);
        return result;
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)element;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile containingFile = psiClass.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                return JavaLanguage.INSTANCE.equals(containingFile.getLanguage()) ? psiClass : null;
            }
            element = element.getParent();
        }
        return null;
    }
}

