/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.ClassInfoProcessor;
import com.intellij.openapi.diagnostic.Logger;

public class DependencyCacheNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.DependencyCacheNavigator");
    private final Cache myCache;

    public DependencyCacheNavigator(Cache cache) {
        this.myCache = cache;
    }

    public void walkSuperClasses(int classQName, ClassInfoProcessor processor) throws CacheCorruptedException {
        if (classQName == -1) {
            return;
        }
        int superQName = this.myCache.getSuperQualifiedName(classQName);
        if (classQName == superQName) {
            LOG.error("Superclass qualified name is the same as class' name: " + classQName);
            return;
        }
        if (superQName != -1 && processor.process(superQName)) {
            this.walkSuperClasses(superQName, processor);
        }
        for (int superInterfaceQName : this.myCache.getSuperInterfaces(classQName)) {
            if (!processor.process(superInterfaceQName)) continue;
            this.walkSuperClasses(superInterfaceQName, processor);
        }
    }

    public void walkSuperInterfaces(int classQName, ClassInfoProcessor processor) throws CacheCorruptedException {
        if (classQName == -1) {
            return;
        }
        for (int superInterfaceQName : this.myCache.getSuperInterfaces(classQName)) {
            if (!processor.process(superInterfaceQName)) continue;
            this.walkSuperInterfaces(superInterfaceQName, processor);
        }
    }

    public void walkSubClasses(int fromClassQName, ClassInfoProcessor processor) throws CacheCorruptedException {
        for (int subQName : this.myCache.getSubclasses(fromClassQName)) {
            if (fromClassQName == subQName) {
                LOG.error("Subclass qualified name is the same as class' name: " + fromClassQName);
                return;
            }
            if (subQName != -1 && !processor.process(subQName)) break;
        }
    }
}

