/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CachingSearcher;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangedConstantsDependencyProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.ChangedConstantsDependencyProcessor");
    private final Project myProject;
    private final CachingSearcher mySearcher;
    private final DependencyCache myDependencyCache;
    private final int myQName;
    private final CompileContext myContext;
    private final FieldChangeInfo[] myChangedFields;
    private final FieldChangeInfo[] myRemovedFields;
    private final int MAX_CONSTANT_SEARCHES = Registry.intValue((String)"compiler.max.static.constants.searches");
    private static final Key<Integer> CONSTANTS_COUNTER = Key.create((String)"_constant_searches_counter_");

    public ChangedConstantsDependencyProcessor(Project project, CachingSearcher searcher, DependencyCache dependencyCache, int qName, CompileContext context, FieldChangeInfo[] changedFields, FieldChangeInfo[] removedFields) {
        this.myProject = project;
        this.mySearcher = searcher;
        this.myDependencyCache = dependencyCache;
        this.myQName = qName;
        this.myContext = context;
        this.myChangedFields = changedFields;
        this.myRemovedFields = removedFields;
    }

    public void run() throws CacheCorruptedException, ExitException {
        final Ref _ex = new Ref();
        final Ref exitException = new Ref(null);
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiClass[] classes;
                    String qName = ChangedConstantsDependencyProcessor.this.myDependencyCache.resolve(ChangedConstantsDependencyProcessor.this.myQName);
                    for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)ChangedConstantsDependencyProcessor.this.myProject).findClasses(qName.replace('$', '.'), GlobalSearchScope.allScope((Project)ChangedConstantsDependencyProcessor.this.myProject))) {
                        PsiField[] psiFields;
                        for (PsiField psiField : psiFields = aClass.getFields()) {
                            FieldChangeInfo changeInfo = ChangedConstantsDependencyProcessor.this.findChangeInfo(psiField);
                            if (changeInfo == null) continue;
                            ChangedConstantsDependencyProcessor.this.processFieldChanged(psiField, aClass, changeInfo.isAccessibilityChange);
                        }
                        for (FieldChangeInfo fieldChangeInfo : ChangedConstantsDependencyProcessor.this.myRemovedFields) {
                            ChangedConstantsDependencyProcessor.this.processFieldRemoved(fieldChangeInfo.fieldInfo, aClass);
                        }
                    }
                }
                catch (CacheCorruptedException e) {
                    _ex.set((Object)e);
                }
                catch (ExitException e) {
                    exitException.set((Object)e);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        });
        if (_ex.get() != null) {
            throw (CacheCorruptedException)_ex.get();
        }
        if (exitException.get() != null) {
            throw (ExitException)exitException.get();
        }
    }

    private void processFieldRemoved(FieldInfo info, final PsiClass aClass) throws CacheCorruptedException {
        PsiFile containingFile;
        if (info.isPrivate()) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (info.isPackageLocal() && (containingFile = aClass.getContainingFile()) instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage != null) {
                searchScope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
                searchScope = searchScope.intersectWith(aClass.getUseScope());
            }
        }
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        final Ref exRef = new Ref(null);
        ChangedConstantsDependencyProcessor.processIdentifiers(psiSearchHelper, new PsiElementProcessor<PsiIdentifier>(){

            public synchronized boolean execute(@NotNull PsiIdentifier identifier) {
                if (identifier == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/ChangedConstantsDependencyProcessor$2", "execute"));
                }
                try {
                    PsiClass ownerClass;
                    PsiElement parent = identifier.getParent();
                    if (parent instanceof PsiReferenceExpression && (ownerClass = ChangedConstantsDependencyProcessor.getOwnerClass(parent)) != null && !ownerClass.equals(aClass)) {
                        String _qName = ownerClass.getQualifiedName();
                        if (_qName != null) {
                            int qualifiedName = ChangedConstantsDependencyProcessor.this.myDependencyCache.getSymbolTable().getId(_qName);
                            if (ChangedConstantsDependencyProcessor.this.myDependencyCache.markClass(qualifiedName, true) && LOG.isDebugEnabled()) {
                                LOG.debug("Mark dependent class " + ChangedConstantsDependencyProcessor.this.myDependencyCache.resolve(qualifiedName) + "; reason: some constants were removed from " + ChangedConstantsDependencyProcessor.this.myDependencyCache.resolve(ChangedConstantsDependencyProcessor.this.myQName));
                            }
                        } else {
                            LOG.warn("Class with null qualified name was not expected here: " + ownerClass);
                        }
                    }
                    return true;
                }
                catch (CacheCorruptedException e) {
                    exRef.set((Object)e);
                    return false;
                }
            }
        }, this.myDependencyCache.resolve(info.getName()), (SearchScope)searchScope, (short)1);
        CacheCorruptedException cacheCorruptedException = (CacheCorruptedException)exRef.get();
        if (cacheCorruptedException != null) {
            throw cacheCorruptedException;
        }
    }

    private static boolean processIdentifiers(PsiSearchHelper helper, final @NotNull PsiElementProcessor<PsiIdentifier> processor, @NotNull String identifier, @NotNull SearchScope searchScope, short searchContext) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/make/ChangedConstantsDependencyProcessor", "processIdentifiers"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/make/ChangedConstantsDependencyProcessor", "processIdentifiers"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/compiler/make/ChangedConstantsDependencyProcessor", "processIdentifiers"));
        }
        TextOccurenceProcessor processor1 = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                return !(element instanceof PsiIdentifier) || processor.execute((PsiElement)((PsiIdentifier)element));
            }
        };
        return helper.processElementsWithWord(processor1, searchScope, identifier, searchContext, true);
    }

    private void processFieldChanged(PsiField field, PsiClass aClass, boolean isAccessibilityChange) throws CacheCorruptedException, ExitException {
        if (!isAccessibilityChange && field.hasModifierProperty("private")) {
            return;
        }
        HashSet<PsiElement> usages = new HashSet<PsiElement>();
        this.addUsages(field, usages, isAccessibilityChange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("++++++++++++++++++++++++++++++++++++++++++++++++");
            LOG.debug("Processing changed field: " + aClass.getQualifiedName() + "." + field.getName());
        }
        for (PsiElement usage : usages) {
            VirtualFile file;
            PsiFile containingFile;
            PsiClass ownerClass = ChangedConstantsDependencyProcessor.getOwnerClass(usage);
            if (LOG.isDebugEnabled()) {
                if (ownerClass != null) {
                    LOG.debug("Usage " + usage + " found in class: " + ownerClass.getQualifiedName());
                } else {
                    LOG.debug("Usage " + usage + " found in class: null");
                }
            }
            if (ownerClass != null && !ownerClass.equals(aClass)) {
                int qualifiedName = this.myDependencyCache.getSymbolTable().getId(ownerClass.getQualifiedName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking class id = [" + qualifiedName + "], name=[" + this.myDependencyCache.resolve(qualifiedName) + "]");
                }
                if (!this.myDependencyCache.markClass(qualifiedName, true) || !LOG.isDebugEnabled()) continue;
                LOG.debug("Marked dependent class " + this.myDependencyCache.resolve(qualifiedName) + "; reason: constants changed in " + this.myDependencyCache.resolve(this.myQName));
                continue;
            }
            if (ownerClass != null || (containingFile = usage.getContainingFile()) == null || (file = containingFile.getVirtualFile()) == null) continue;
            this.myDependencyCache.markFile(file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("+++++++++++++++++++++++++++++++++++++++++++++++");
        }
    }

    private void addUsages(PsiField psiField, Collection<PsiElement> usages, boolean ignoreAccessScope) throws ExitException {
        int count = this.getConstantSearchesCount();
        if (count > this.MAX_CONSTANT_SEARCHES) {
            this.myContext.requestRebuildNextTime("Too many changed compile-time constants, project rebuild scheduled");
            throw new ExitException(ExitStatus.CANCELLED);
        }
        Collection<PsiReference> references = this.mySearcher.findReferences((PsiElement)psiField, ignoreAccessScope);
        this.incConstantSearchesCount();
        for (PsiReference ref : references) {
            PsiExpression initializer;
            if (!(ref instanceof PsiReferenceExpression)) continue;
            PsiElement e = ref.getElement();
            usages.add(e);
            PsiField ownerField = ChangedConstantsDependencyProcessor.getOwnerField(e);
            if (ownerField == null || !ownerField.hasModifierProperty("final") || (initializer = ownerField.getInitializer()) == null || !PsiUtil.isConstantExpression((PsiExpression)initializer)) continue;
            this.addUsages(ownerField, usages, ignoreAccessScope);
        }
    }

    @Nullable
    private static PsiField getOwnerField(PsiElement element) {
        while (!(element instanceof PsiFile) && !(element instanceof PsiClass)) {
            if (element instanceof PsiField) {
                return (PsiField)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private FieldChangeInfo findChangeInfo(PsiField field) throws CacheCorruptedException {
        String name = field.getName();
        for (FieldChangeInfo changeInfo : this.myChangedFields) {
            if (!name.equals(this.myDependencyCache.resolve(changeInfo.fieldInfo.getName()))) continue;
            return changeInfo;
        }
        return null;
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)element;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile containingFile = psiClass.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                return StdLanguages.JAVA.equals(containingFile.getLanguage()) ? psiClass : null;
            }
            element = element.getParent();
        }
        return null;
    }

    private int getConstantSearchesCount() {
        return ChangedConstantsDependencyProcessor.getConstantSearchesCount(this.myContext);
    }

    public static int getConstantSearchesCount(CompileContext context) {
        Integer value = (Integer)CONSTANTS_COUNTER.get((UserDataHolder)context);
        return value != null ? value : 0;
    }

    private void incConstantSearchesCount() {
        CONSTANTS_COUNTER.set((UserDataHolder)this.myContext, (Object)(this.getConstantSearchesCount() + 1));
    }

    public static class FieldChangeInfo {
        final FieldInfo fieldInfo;
        final boolean isAccessibilityChange;

        public FieldChangeInfo(FieldInfo fieldId) {
            this(fieldId, false);
        }

        public FieldChangeInfo(FieldInfo fieldInfo, boolean accessibilityChange) {
            this.fieldInfo = fieldInfo;
            this.isAccessibilityChange = accessibilityChange;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldChangeInfo fieldChangeInfo = (FieldChangeInfo)o;
            if (this.isAccessibilityChange != fieldChangeInfo.isAccessibilityChange) {
                return false;
            }
            return this.fieldInfo.equals(fieldChangeInfo.fieldInfo);
        }

        public int hashCode() {
            int result = this.fieldInfo.hashCode();
            result = 29 * result + (this.isAccessibilityChange ? 1 : 0);
            return result;
        }
    }
}

