/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.resourceCompiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.resourceCompiler.ResourceCompilerExtension;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Chunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResourceCompiler
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.resourceCompiler.ResourceCompiler");
    private final Project myProject;
    private final CompilerConfiguration myConfiguration;
    private final ResourceCompilerExtension[] myResourceCompilerExtensions = (ResourceCompilerExtension[])ResourceCompilerExtension.EP_NAME.getExtensions();

    public ResourceCompiler(Project project, CompilerConfiguration compilerConfiguration) {
        this.myProject = project;
        this.myConfiguration = compilerConfiguration;
    }

    @NotNull
    public String getDescription() {
        String string = CompilerBundle.message((String)"resource.compiler.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/resourceCompiler/ResourceCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject)).convertPatterns();
        return true;
    }

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        Module module = context.getModuleByFile(file);
        if (module != null && this.skipStandardResourceCompiler(module)) {
            return false;
        }
        return this.myConfiguration.isResourceFile(file);
    }

    public void compile(final CompileContext context, Chunk<Module> moduleChunk, final VirtualFile[] files, TranslatingCompiler.OutputSink sink) {
        context.getProgressIndicator().pushState();
        context.getProgressIndicator().setText(CompilerBundle.message((String)"progress.copying.resources", (Object[])new Object[0]));
        final HashMap<String, Collection<TranslatingCompiler.OutputItem>> processed = new HashMap<String, Collection<TranslatingCompiler.OutputItem>>();
        final LinkedList copyCommands = new LinkedList();
        final Module singleChunkModule = moduleChunk.getNodes().size() == 1 ? (Module)moduleChunk.getNodes().iterator().next() : null;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)ResourceCompiler.this.myProject).getFileIndex();
                for (VirtualFile file : files) {
                    VirtualFile outputDir;
                    VirtualFile fileRoot;
                    Module module;
                    if (context.getProgressIndicator().isCanceled()) break;
                    Module module2 = module = singleChunkModule != null ? singleChunkModule : context.getModuleByFile(file);
                    if (module == null || (fileRoot = MakeUtil.getSourceRoot(context, module, file)) == null) continue;
                    String sourcePath = file.getPath();
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)fileRoot, (char)'/');
                    boolean inTests = ((CompileContextEx)context).isInTestSourceContent(file);
                    VirtualFile virtualFile = outputDir = inTests ? context.getModuleOutputDirectoryForTests(module) : context.getModuleOutputDirectory(module);
                    if (outputDir == null) continue;
                    String outputPath = outputDir.getPath();
                    String packagePrefix = fileIndex.getPackageNameByDirectory(fileRoot);
                    String targetPath = packagePrefix != null && packagePrefix.length() > 0 ? outputPath + "/" + packagePrefix.replace('.', '/') + "/" + relativePath : outputPath + "/" + relativePath;
                    if (sourcePath.equals(targetPath)) {
                        ResourceCompiler.addToMap(processed, outputPath, new MyOutputItem(targetPath, file));
                        continue;
                    }
                    copyCommands.add(new CopyCommand(outputPath, sourcePath, targetPath, file));
                }
            }
        });
        ArrayList<File> filesToRefresh = new ArrayList<File>();
        while (!copyCommands.isEmpty()) {
            CopyCommand command = (CopyCommand)copyCommands.removeFirst();
            if (context.getProgressIndicator().isCanceled()) break;
            context.getProgressIndicator().setText2("Copying " + command.getFromPath() + "...");
            try {
                MyOutputItem outputItem = command.copy(filesToRefresh);
                ResourceCompiler.addToMap(processed, command.getOutputPath(), outputItem);
            }
            catch (IOException e) {
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"error.copying", (Object[])new Object[]{command.getFromPath(), command.getToPath(), e.getMessage()}), command.getSourceFileUrl(), -1, -1);
            }
        }
        if (!filesToRefresh.isEmpty()) {
            CompilerUtil.refreshIOFiles(filesToRefresh);
            filesToRefresh.clear();
        }
        Iterator it = processed.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sink.add((String)entry.getKey(), (Collection)entry.getValue(), VirtualFile.EMPTY_ARRAY);
            it.remove();
        }
        context.getProgressIndicator().popState();
    }

    private boolean skipStandardResourceCompiler(Module module) {
        for (ResourceCompilerExtension extension : this.myResourceCompilerExtensions) {
            if (!extension.skipStandardResourceCompiler(module)) continue;
            return true;
        }
        return false;
    }

    private static void addToMap(Map<String, Collection<TranslatingCompiler.OutputItem>> map, String outputDir, TranslatingCompiler.OutputItem item) {
        Collection<TranslatingCompiler.OutputItem> list = map.get(outputDir);
        if (list == null) {
            list = new ArrayList<TranslatingCompiler.OutputItem>();
            map.put(outputDir, list);
        }
        list.add(item);
    }

    private static class MyOutputItem
    implements TranslatingCompiler.OutputItem {
        private final String myTargetPath;
        private final VirtualFile myFile;

        private MyOutputItem(String targetPath, VirtualFile sourceFile) {
            this.myTargetPath = targetPath;
            this.myFile = sourceFile;
        }

        public String getOutputPath() {
            return this.myTargetPath;
        }

        public VirtualFile getSourceFile() {
            return this.myFile;
        }
    }

    private static class CopyCommand {
        private final String myOutputPath;
        private final String myFromPath;
        private final String myToPath;
        private final VirtualFile mySourceFile;

        private CopyCommand(String outputPath, String fromPath, String toPath, VirtualFile sourceFile) {
            this.myOutputPath = outputPath;
            this.myFromPath = fromPath;
            this.myToPath = toPath;
            this.mySourceFile = sourceFile;
        }

        public MyOutputItem copy(List<File> filesToRefresh) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying " + this.myFromPath + " to " + this.myToPath);
            }
            File targetFile = new File(this.myToPath);
            FileUtil.copyContent((File)new File(this.myFromPath), (File)targetFile);
            filesToRefresh.add(targetFile);
            return new MyOutputItem(this.myToPath, this.mySourceFile);
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public String getFromPath() {
            return this.myFromPath;
        }

        public String getToPath() {
            return this.myToPath;
        }

        public String getSourceFileUrl() {
            return VirtualFileManager.constructUrl((String)this.mySourceFile.getFileSystem().getProtocol(), (String)this.myFromPath);
        }
    }
}

