/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.DependentJarsEvaluator;
import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarsBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.packagingCompiler.JarsBuilder");
    private final Set<JarInfo> myJarsToBuild;
    private final FileFilter myFileFilter;
    private final CompileContext myContext;
    private Map<JarInfo, File> myBuiltJars;

    public JarsBuilder(Set<JarInfo> jarsToBuild, FileFilter fileFilter, CompileContext context) {
        DependentJarsEvaluator evaluator = new DependentJarsEvaluator();
        for (JarInfo jarInfo : jarsToBuild) {
            evaluator.addJarWithDependencies(jarInfo);
        }
        this.myJarsToBuild = evaluator.getJars();
        this.myFileFilter = fileFilter;
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildJars(Set<String> writtenPaths) throws IOException {
        this.myContext.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.building.archives", (Object[])new Object[0]));
        JarInfo[] sortedJars = this.sortJars();
        if (sortedJars == null) {
            return false;
        }
        this.myBuiltJars = new HashMap<JarInfo, File>();
        try {
            for (JarInfo jar : sortedJars) {
                this.myContext.getProgressIndicator().checkCanceled();
                this.buildJar(jar);
            }
            this.myContext.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.copying.archives", (Object[])new Object[0]));
            this.copyJars(writtenPaths);
        }
        finally {
            this.deleteTemporaryJars();
        }
        return true;
    }

    private void deleteTemporaryJars() {
        for (File file : this.myBuiltJars.values()) {
            FileUtil.delete((File)file);
        }
    }

    private void copyJars(Set<String> writtenPaths) throws IOException {
        for (Map.Entry<JarInfo, File> entry : this.myBuiltJars.entrySet()) {
            File fromFile = entry.getValue();
            boolean first = true;
            for (DestinationInfo destination : entry.getKey().getAllDestinations()) {
                if (!(destination instanceof ExplodedDestinationInfo)) continue;
                File toFile = new File(FileUtil.toSystemDependentName((String)destination.getOutputPath()));
                if (first) {
                    first = false;
                    JarsBuilder.renameFile(fromFile, toFile, writtenPaths);
                    fromFile = toFile;
                    continue;
                }
                DeploymentUtil.getInstance().copyFile(fromFile, toFile, this.myContext, writtenPaths, this.myFileFilter);
            }
        }
    }

    private static void renameFile(File fromFile, File toFile, Set<String> writtenPaths) throws IOException {
        FileUtil.rename((File)fromFile, (File)toFile);
        writtenPaths.add(toFile.getPath());
    }

    @Nullable
    private JarInfo[] sortJars() {
        DFSTBuilder builder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new JarsGraph())));
        if (!builder.isAcyclic()) {
            Pair dependency = builder.getCircularDependency();
            String message = CompilerBundle.message((String)"packaging.compiler.error.cannot.build.circular.dependency.found.between.0.and.1", (Object[])new Object[]{((JarInfo)dependency.getFirst()).getPresentableDestination(), ((JarInfo)dependency.getSecond()).getPresentableDestination()});
            this.myContext.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            return null;
        }
        Object[] jars = this.myJarsToBuild.toArray(new JarInfo[this.myJarsToBuild.size()]);
        Arrays.sort(jars, builder.comparator());
        jars = (JarInfo[])ArrayUtil.reverseArray((Object[])jars);
        return jars;
    }

    public Set<JarInfo> getJarsToBuild() {
        return this.myJarsToBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(JarInfo jar) throws IOException {
        if (jar.getPackedFiles().isEmpty() && jar.getPackedJars().isEmpty()) {
            this.myContext.addMessage(CompilerMessageCategory.WARNING, "Archive '" + jar.getPresentableDestination() + "' has no files so it won't be created", null, -1, -1);
            return;
        }
        this.myContext.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.building.0", (Object[])new Object[]{jar.getPresentableDestination()}));
        File jarFile = FileUtil.createTempFile((String)"artifactCompiler", (String)"tmp");
        this.myBuiltJars.put(jar, jarFile);
        FileUtil.createParentDirs((File)jarFile);
        VirtualFile manifestFile = null;
        for (Pair<String, VirtualFile> pair : jar.getPackedFiles()) {
            if (!((String)pair.getFirst()).equals("META-INF/MANIFEST.MF")) continue;
            manifestFile = (VirtualFile)pair.getSecond();
        }
        JarOutputStream jarOutputStream = JarsBuilder.createJarOutputStream(jarFile, manifestFile);
        try {
            THashSet writtenPaths = new THashSet();
            for (Pair<String, VirtualFile> pair : jar.getPackedFiles()) {
                if (((String)pair.getFirst()).equals("META-INF/MANIFEST.MF")) continue;
                VirtualFile sourceFile = (VirtualFile)pair.getSecond();
                if (sourceFile.isInLocalFileSystem()) {
                    File file = VfsUtil.virtualToIoFile((VirtualFile)sourceFile);
                    this.addFileToJar(jarOutputStream, file, (String)pair.getFirst(), (THashSet<String>)writtenPaths);
                    continue;
                }
                this.extractFileAndAddToJar(jarOutputStream, sourceFile, (String)pair.getFirst(), (THashSet<String>)writtenPaths);
            }
            for (Pair pair : jar.getPackedJars()) {
                File nestedJarFile = this.myBuiltJars.get(pair.getSecond());
                if (nestedJarFile != null) {
                    this.addFileToJar(jarOutputStream, nestedJarFile, (String)pair.getFirst(), (THashSet<String>)writtenPaths);
                    continue;
                }
                LOG.debug("nested jar file " + (String)pair.getFirst() + " for " + jar.getPresentableDestination() + " not found");
            }
        }
        finally {
            jarOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarOutputStream createJarOutputStream(File jarFile, VirtualFile manifestFile) throws IOException {
        JarOutputStream jarOutputStream;
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(jarFile));
        if (manifestFile != null) {
            InputStream manifestStream = manifestFile.getInputStream();
            try {
                jarOutputStream = new JarOutputStream((OutputStream)outputStream, new Manifest(manifestStream));
            }
            finally {
                manifestStream.close();
            }
        } else {
            jarOutputStream = new JarOutputStream(outputStream);
        }
        return jarOutputStream;
    }

    private void extractFileAndAddToJar(JarOutputStream jarOutputStream, VirtualFile sourceFile, String relativePath, THashSet<String> writtenPaths) throws IOException {
        relativePath = JarsBuilder.addParentDirectories(jarOutputStream, writtenPaths, relativePath);
        this.myContext.getProgressIndicator().setText2(relativePath);
        if (!writtenPaths.add((Object)relativePath)) {
            return;
        }
        BufferedInputStream input = ArtifactCompilerUtil.getJarEntryInputStream(sourceFile, this.myContext);
        if (input == null) {
            return;
        }
        ZipEntry entry = new ZipEntry(relativePath);
        entry.setTime(ArtifactCompilerUtil.getJarFile(sourceFile).lastModified());
        jarOutputStream.putNextEntry(entry);
        FileUtil.copy((InputStream)input, (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private void addFileToJar(@NotNull JarOutputStream jarOutputStream, @NotNull File file, @NotNull String relativePath, @NotNull THashSet<String> writtenPaths) throws IOException {
        if (jarOutputStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/packagingCompiler/JarsBuilder", "addFileToJar"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/packagingCompiler/JarsBuilder", "addFileToJar"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/impl/packagingCompiler/JarsBuilder", "addFileToJar"));
        }
        if (writtenPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/compiler/impl/packagingCompiler/JarsBuilder", "addFileToJar"));
        }
        if (!file.exists()) {
            return;
        }
        relativePath = JarsBuilder.addParentDirectories(jarOutputStream, writtenPaths, relativePath);
        this.myContext.getProgressIndicator().setText2(relativePath);
        ZipUtil.addFileToZip((ZipOutputStream)jarOutputStream, (File)file, (String)relativePath, writtenPaths, (FileFilter)this.myFileFilter);
    }

    private static String addParentDirectories(JarOutputStream jarOutputStream, THashSet<String> writtenPaths, String relativePath) throws IOException {
        while (StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = relativePath.substring(1);
        }
        int i = relativePath.indexOf(47);
        while (i != -1) {
            String prefix = relativePath.substring(0, i + 1);
            if (!writtenPaths.contains((Object)prefix) && prefix.length() > 1) {
                JarsBuilder.addEntry(jarOutputStream, prefix);
                writtenPaths.add((Object)prefix);
            }
            i = relativePath.indexOf(47, i + 1);
        }
        return relativePath;
    }

    private static void addEntry(ZipOutputStream output, @NonNls String relativePath) throws IOException {
        ZipEntry e = new ZipEntry(relativePath);
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        output.putNextEntry(e);
        output.closeEntry();
    }

    private class JarsGraph
    implements GraphGenerator.SemiGraph<JarInfo> {
        private JarsGraph() {
        }

        public Collection<JarInfo> getNodes() {
            return JarsBuilder.this.myJarsToBuild;
        }

        public Iterator<JarInfo> getIn(JarInfo n) {
            HashSet<JarInfo> ins = new HashSet<JarInfo>();
            for (JarDestinationInfo destination : n.getJarDestinations()) {
                ins.add(destination.getJarInfo());
            }
            return ins.iterator();
        }
    }
}

