/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.openapi.compiler.make.BuildInstruction;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public abstract class BuildInstructionBase
extends UserDataHolderBase
implements BuildInstruction,
Cloneable {
    private final String myOutputRelativePath;
    private Collection<File> myFilesToDelete;

    protected BuildInstructionBase(String outputRelativePath) {
        this.myOutputRelativePath = outputRelativePath;
    }

    public String getOutputRelativePath() {
        return this.myOutputRelativePath;
    }

    public BuildInstructionBase clone() {
        return (BuildInstructionBase)super.clone();
    }

    public void addFileToDelete(File file) {
        if (this.myFilesToDelete == null) {
            this.myFilesToDelete = new THashSet();
        }
        this.myFilesToDelete.add(file);
    }

    public void collectFilesToDelete(Collection<File> filesToDelete) {
        if (this.myFilesToDelete != null) {
            filesToDelete.addAll(this.myFilesToDelete);
        }
        this.myFilesToDelete = null;
    }

    @NonNls
    public String toString() {
        return super.toString();
    }

    protected File createTempFile(String prefix, String suffix) throws IOException {
        File tempFile = FileUtil.createTempFile((String)(prefix + "___"), (String)suffix);
        this.addFileToDelete(tempFile);
        return tempFile;
    }
}

