/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.impl.javaCompiler.api.CompAPIDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.Nullable;

class Output
extends SimpleJavaFileObject {
    private final CompAPIDriver myCompAPIDriver;
    @Nullable
    private volatile byte[] myFileBytes;

    Output(URI uri, CompAPIDriver compAPIDriver, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.myCompAPIDriver = compAPIDriver;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = this.toByteArray();
                Output.access$002(Output.this, bytes);
                if (JavaFileObject.Kind.CLASS.equals((Object)Output.this.kind)) {
                    Output.this.myCompAPIDriver.offerClassFile(Output.this.toUri(), bytes);
                }
            }
        };
    }

    @Override
    public InputStream openInputStream() throws IOException {
        byte[] bytes = this.myFileBytes;
        if (bytes == null) {
            throw new FileNotFoundException(this.toUri().getPath());
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        byte[] bytes = this.myFileBytes;
        if (bytes == null) {
            throw null;
        }
        return new String(bytes);
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }

    static /* synthetic */ byte[] access$002(Output x0, byte[] x1) {
        x0.myFileBytes = x1;
        return x1;
    }
}

