/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.impl.javaCompiler.api.CompAPIDriver;
import com.intellij.compiler.impl.javaCompiler.api.FileVirtualObject;
import com.intellij.compiler.impl.javaCompiler.api.JavaIoFile;
import com.intellij.compiler.impl.javaCompiler.api.JavaVirtualFile;
import com.intellij.compiler.impl.javaCompiler.api.Output;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.sun.tools.javac.util.ListBuffer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;

class MyFileManager
implements StandardJavaFileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.api.MyFileManager");
    private final String myOutputDir;
    private final StandardJavaFileManager myStandardFileManager;
    private final String myEncoding;
    private final CompAPIDriver myCompAPIDriver;

    MyFileManager(CompAPIDriver compAPIDriver, String outputDir, StandardJavaFileManager standardFileManager, String encoding) {
        this.myCompAPIDriver = compAPIDriver;
        this.myOutputDir = outputDir;
        this.myStandardFileManager = standardFileManager;
        this.myEncoding = encoding;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        int size = ((Collection)files).size();
        ArrayList<JavaIoFile> result = new ArrayList<JavaIoFile>(size);
        for (File file : files) {
            JavaIoFile fileObject = new JavaIoFile(file, JavaFileObject.Kind.SOURCE, this.myEncoding);
            result.add(fileObject);
        }
        return result;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject fileObject) {
        URI uri = MyFileManager.toURI(this.myOutputDir, name, kind);
        return new Output(uri, this.myCompAPIDriver, kind);
    }

    static URI createUri(String url) {
        return URI.create(url.replaceAll(" ", "%20"));
    }

    private static URI toURI(String outputDir, String name, JavaFileObject.Kind kind) {
        return MyFileManager.createUri("file:///" + outputDir.replace('\\', '/') + "/" + name.replace('.', '/') + kind.extension);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (recurse) {
            throw new IllegalArgumentException();
        }
        return this.findInside(location, packageName, kinds, false);
    }

    private List<JavaFileObject> findInside(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean lookForFile) throws IOException {
        List<JavaFileObject> ret;
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return Collections.emptyList();
        }
        String subdirectory = packageName.replace('.', '/');
        SmartList results = null;
        for (File file : path) {
            VirtualFile[] children;
            VirtualFile virtualFile;
            VirtualFile dir = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (dir == null || !dir.isDirectory() && (dir = JarFileSystem.getInstance().getJarRootForLocalFile(dir)) == null || (virtualFile = StringUtil.isEmptyOrSpaces((String)subdirectory) ? dir : dir.findFileByRelativePath(subdirectory)) == null) continue;
            if (lookForFile) {
                if (virtualFile.isDirectory()) continue;
                children = new VirtualFile[]{virtualFile};
            } else {
                children = virtualFile.getChildren();
            }
            for (VirtualFile child : children) {
                JavaFileObject.Kind kind = MyFileManager.getKind("." + child.getExtension());
                if (kinds != null && !kinds.contains((Object)kind)) continue;
                if (results == null) {
                    results = new SmartList();
                }
                if (kind == JavaFileObject.Kind.SOURCE && child.getFileSystem() instanceof JarFileSystem) continue;
                String childPath = child.getPath();
                SimpleJavaFileObject fileObject = !childPath.contains("!/") ? new JavaIoFile(new File(childPath), kind, this.myEncoding) : new JavaVirtualFile(child, kind);
                results.add(fileObject);
            }
        }
        List<JavaFileObject> list = ret = results == null ? Collections.emptyList() : results;
        if (LOG.isDebugEnabled()) {
            Collection collection = (Collection)this.myStandardFileManager.list(location, packageName, kinds, false);
            HashSet sup = new HashSet(collection);
            assert (sup.size() == collection.size());
            assert (new HashSet(collection).equals(sup));
            THashSet s = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<JavaFileObject>(){

                public int computeHashCode(JavaFileObject object) {
                    return object.getName().hashCode();
                }

                public boolean equals(JavaFileObject o1, JavaFileObject o2) {
                    return o1.getKind() == o2.getKind() && o1.toUri().equals(o2.toUri());
                }
            });
            s.addAll(ret);
            s.removeAll(sup);
            if (ret.size() != sup.size()) assert (false) : "our implementation differs from javac'";
        }
        return ret;
    }

    private static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return FileUtil.getNameWithoutExtension((String)new File(file.getName()).getName());
    }

    @Override
    public int isSupportedOption(String option) {
        return this.myStandardFileManager.isSupportedOption(option);
    }

    @Override
    public void close() throws IOException {
        this.myStandardFileManager.close();
    }

    @Override
    public void flush() throws IOException {
        this.myStandardFileManager.flush();
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.myStandardFileManager.handleOption(current, remaining);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.myStandardFileManager.getClassLoader(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (a instanceof FileVirtualObject && b instanceof FileVirtualObject || a instanceof Output && b instanceof Output) {
            return a.equals(b);
        }
        return this.myStandardFileManager.isSameFile(a, b);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(names));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<File> files = new ListBuffer<File>();
        for (String name : names) {
            files.append(new File(name));
        }
        return this.getJavaFileObjectsFromFiles(files.toList());
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        List<JavaFileObject> result = this.findInside(location, className, kind == null ? null : Collections.singleton(kind), true);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.getJavaFileForInput(location, packageName + "/" + relativeName, MyFileManager.getKind(relativeName));
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.getJavaFileForOutput(location, packageName + "/" + relativeName, MyFileManager.getKind(relativeName), null);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return this.myStandardFileManager.getLocation(location);
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        this.myStandardFileManager.setLocation(location, path);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.myStandardFileManager.hasLocation(location);
    }
}

